/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

import io.protostuff.parser.DefaultProtoLoader;
import io.protostuff.parser.Field;
import io.protostuff.parser.Message;
import io.protostuff.parser.MessageField;
import io.protostuff.parser.Proto;
import io.protostuff.parser.ProtoParserTest;
import io.protostuff.parser.ProtoUtil;
import java.io.File;
import junit.framework.TestCase;

public class DefaultProtoLoaderTest
extends TestCase {
    public void testPackageBaseDir() throws Exception {
        File f = ProtoParserTest.getFile("io/protostuff/parser/test_default_proto_loader.proto");
        DefaultProtoLoaderTest.assertTrue((boolean)f.exists());
        Proto p = ProtoUtil.parseProto((File)f);
        DefaultProtoLoaderTest.assertEquals((String)"io.protostuff.parser", (String)p.getPackageName());
    }

    public void testLoadProtoFromClasspath() throws Exception {
        Proto proto = DefaultProtoLoader.loadFromClasspath((String)"google/protobuf/unittest_import.proto", null);
        DefaultProtoLoaderTest.assertNotNull((Object)proto);
        DefaultProtoLoaderTest.assertEquals((String)"protobuf_unittest_import", (String)proto.getPackageName());
    }

    public void testImportFromClasspath() throws Exception {
        File f = new File("src/main/etc/test_default_proto_loader.proto");
        DefaultProtoLoaderTest.assertTrue((boolean)f.exists());
        Proto p = ProtoUtil.parseProto((File)f);
        DefaultProtoLoaderTest.assertEquals((String)"io.protostuff.parser", (String)p.getPackageName());
        Message testMessage = p.getMessage("TestMessage");
        DefaultProtoLoaderTest.assertNotNull((Object)testMessage);
        Field f1 = testMessage.getField("imported_message1");
        Field f2 = testMessage.getField("imported_message2");
        DefaultProtoLoaderTest.assertNotNull((Object)f1);
        DefaultProtoLoaderTest.assertNotNull((Object)f2);
        DefaultProtoLoaderTest.assertTrue((boolean)(f1 instanceof MessageField));
        DefaultProtoLoaderTest.assertTrue((boolean)(f2 instanceof MessageField));
        Message importedMessage1 = ((MessageField)f1).getMessage();
        Message importedMessage2 = ((MessageField)f2).getMessage();
        DefaultProtoLoaderTest.assertNotNull((Object)importedMessage1);
        DefaultProtoLoaderTest.assertNotNull((Object)importedMessage2);
        DefaultProtoLoaderTest.assertTrue((importedMessage1 == importedMessage2 ? 1 : 0) != 0);
    }
}

