/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

import io.protostuff.parser.Annotation;
import io.protostuff.parser.EnumGroup;
import io.protostuff.parser.Extension;
import io.protostuff.parser.Field;
import io.protostuff.parser.Message;
import io.protostuff.parser.Proto;
import io.protostuff.parser.ProtoParserTest;
import io.protostuff.parser.ProtoUtil;
import io.protostuff.parser.Service;
import java.io.File;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;

public class AnnotationTest {
    @Test
    public void testIt() throws Exception {
        File f = ProtoParserTest.getFile("io/protostuff/parser/test_annotations.proto");
        Assert.assertTrue((boolean)f.exists());
        Proto proto = new Proto(f);
        ProtoUtil.loadFrom((File)f, (Proto)proto);
        Message person = proto.getMessage("Person");
        Assert.assertNotNull((Object)person);
        Assert.assertEquals((Object)"[ doc1]", (Object)person.getDocs().toString());
        Annotation defaultPerson = person.getAnnotation("DefaultPerson");
        Assert.assertNotNull((Object)defaultPerson);
        Assert.assertEquals((Object)"Anonymous Coward", (Object)defaultPerson.getValue("name"));
        Field age = person.getField("age");
        Assert.assertNotNull((Object)age);
        Assert.assertEquals((Object)"[ doc2]", (Object)age.getDocs().toString());
        Annotation defaultAge = age.getAnnotation("DefaultAge");
        Assert.assertNotNull((Object)defaultAge);
        Assert.assertTrue((boolean)defaultAge.getParams().isEmpty());
        EnumGroup gender = person.getNestedEnumGroup("Gender");
        Assert.assertNotNull((Object)gender);
        Assert.assertEquals((Object)"[ doc3]", (Object)gender.getDocs().toString());
        Annotation defaultGender = gender.getAnnotation("DefaultGender");
        Assert.assertEquals((Object)"MALE", (Object)defaultGender.getValue("value"));
        EnumGroup.Value male = gender.getValue(0);
        Assert.assertNotNull((Object)male);
        Assert.assertEquals((Object)"[ doc4]", (Object)male.getDocs().toString());
        Annotation maleA = male.getAnnotation("Alias");
        Assert.assertNotNull((Object)maleA);
        Assert.assertEquals((Object)"m", (Object)maleA.getValue("value"));
        Assert.assertTrue((person == maleA.getValue("type") ? 1 : 0) != 0);
        EnumGroup.Value female = gender.getValue(1);
        Assert.assertNotNull((Object)female);
        Assert.assertEquals((Object)"[ doc5]", (Object)female.getDocs().toString());
        Annotation femaleA = female.getAnnotation("Alias");
        Assert.assertNotNull((Object)femaleA);
        Assert.assertEquals((Object)"f", (Object)femaleA.getValue("value"));
        Assert.assertTrue((person == femaleA.getValue("type") ? 1 : 0) != 0);
        Message listRequest = person.getNestedMessage("ListRequest");
        Assert.assertNotNull((Object)listRequest);
        Assert.assertEquals((Object)"[ doc6]", (Object)listRequest.getDocs().toString());
        Annotation nestedMessageAnnotation = listRequest.getAnnotation("NestedMessageAnnotation");
        Assert.assertNotNull((Object)nestedMessageAnnotation);
        Assert.assertTrue((boolean)nestedMessageAnnotation.getParams().isEmpty());
        Message response = listRequest.getNestedMessage("Response");
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"[ doc7]", (Object)response.getDocs().toString());
        Annotation deeperMessageAnnotation = response.getAnnotation("DeeperMessageAnnotation");
        Assert.assertNotNull((Object)deeperMessageAnnotation);
        Assert.assertTrue((boolean)deeperMessageAnnotation.getParams().isEmpty());
        Field personField = response.getField("person");
        Assert.assertNotNull((Object)personField);
        Assert.assertEquals((Object)"[ doc8]", (Object)personField.getDocs().toString());
        Annotation deeperMessageFieldAnnotation = personField.getAnnotation("DeeperMessageFieldAnnotation");
        Assert.assertNotNull((Object)deeperMessageFieldAnnotation);
        Assert.assertTrue((deeperMessageFieldAnnotation.getParams().size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)false, (Object)deeperMessageFieldAnnotation.getValue("nullable"));
        Assert.assertEquals((Object)Float.valueOf(1.1f), (Object)deeperMessageFieldAnnotation.getValue("version"));
        Field keyField = response.getField("key");
        Assert.assertNotNull((Object)keyField);
        Assert.assertEquals((Object)"[ doc9]", (Object)keyField.getDocs().toString());
        Annotation testNested = keyField.getAnnotation("TestNested");
        Assert.assertNotNull((Object)testNested);
        Assert.assertTrue((person == testNested.getValue("type") ? 1 : 0) != 0);
        Assert.assertTrue((gender == testNested.getValue("g") ? 1 : 0) != 0);
        Collection extensions = proto.getExtensions();
        Assert.assertTrue((extensions.size() == 1 ? 1 : 0) != 0);
        Extension extendPerson = (Extension)extensions.iterator().next();
        Assert.assertNotNull((Object)extendPerson);
        Assert.assertEquals((Object)"[ doc10]", (Object)extendPerson.getDocs().toString());
        Annotation personExtras = extendPerson.getAnnotation("PersonExtras");
        Assert.assertNotNull((Object)personExtras);
        Assert.assertTrue((boolean)personExtras.getParams().isEmpty());
        Field country = extendPerson.getField("country");
        Assert.assertNotNull((Object)country);
        Assert.assertEquals((Object)"[ doc11]", (Object)country.getDocs().toString());
        Field k = extendPerson.getField("key");
        Assert.assertNotNull((Object)k);
        Assert.assertEquals((Object)"[ doc12]", (Object)k.getDocs().toString());
        Annotation validate = country.getAnnotation("Validate");
        Assert.assertNotNull((Object)validate);
        Assert.assertTrue((boolean)validate.getParams().isEmpty());
        Service personService = proto.getService("PersonService");
        Assert.assertNotNull((Object)personService);
        Assert.assertEquals((Object)"[ doc13]", (Object)personService.getDocs().toString());
        Assert.assertTrue((personService.getAnnotationMap().size() == 2 ? 1 : 0) != 0);
        Annotation someServiceAnnotation = personService.getAnnotation("SomeServiceAnnotation");
        Annotation anotherServiceAnnotation = personService.getAnnotation("AnotherServiceAnnotation");
        Assert.assertTrue((someServiceAnnotation != null && someServiceAnnotation.getParams().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((anotherServiceAnnotation != null && anotherServiceAnnotation.getParams().isEmpty() ? 1 : 0) != 0);
        Service.RpcMethod put = personService.getRpcMethod("Put");
        Assert.assertNotNull((Object)put);
        Assert.assertEquals((Object)"[ doc14]", (Object)put.getDocs().toString());
        Annotation authRequired = put.getAnnotation("AuthRequired");
        Assert.assertNotNull((Object)authRequired);
        Assert.assertTrue((authRequired.getParams().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"admin", (Object)authRequired.getValue("role"));
        Service.RpcMethod list = personService.getRpcMethod("List");
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((Object)"[ doc15]", (Object)list.getDocs().toString());
        Annotation testRpc = list.getAnnotation("TestRpc");
        Assert.assertNotNull((Object)testRpc);
        Assert.assertTrue((person == testRpc.getValue("type") ? 1 : 0) != 0);
        Assert.assertTrue((gender == testRpc.getValue("g") ? 1 : 0) != 0);
    }
}

