/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.extension.matcher;

import io.opentelemetry.javaagent.extension.matcher.SafeErasureMatcher;
import io.opentelemetry.javaagent.extension.matcher.Utils;
import io.opentelemetry.javaagent.extension.matcher.internal.DelegatingSuperTypeMatcher;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;

class SafeHasSuperTypeMatcher
extends ElementMatcher.Junction.AbstractBase<TypeDescription>
implements DelegatingSuperTypeMatcher {
    private static final Logger logger = Logger.getLogger(SafeHasSuperTypeMatcher.class.getName());
    private final ElementMatcher<TypeDescription.Generic> matcher;
    private final boolean interfacesOnly;

    public SafeHasSuperTypeMatcher(ElementMatcher<TypeDescription.Generic> matcher, boolean interfacesOnly) {
        this.matcher = matcher;
        this.interfacesOnly = interfacesOnly;
    }

    public boolean matches(TypeDescription target) {
        HashSet<TypeDescription> checkedInterfaces = new HashSet<TypeDescription>(8);
        TypeDescription typeDefinition = target;
        while (typeDefinition != null) {
            if ((!this.interfacesOnly || typeDefinition.isInterface()) && this.matcher.matches((Object)typeDefinition.asGenericType()) || this.hasInterface((TypeDefinition)typeDefinition, checkedInterfaces)) {
                return true;
            }
            typeDefinition = SafeHasSuperTypeMatcher.safeGetSuperClass((TypeDefinition)typeDefinition);
        }
        return false;
    }

    private boolean hasInterface(TypeDefinition typeDefinition, Set<TypeDescription> checkedInterfaces) {
        for (TypeDefinition interfaceType : SafeHasSuperTypeMatcher.safeGetInterfaces(typeDefinition)) {
            TypeDescription erasure = SafeErasureMatcher.safeAsErasure(interfaceType);
            if (erasure == null || !checkedInterfaces.add(interfaceType.asErasure()) || !this.matcher.matches((Object)interfaceType.asGenericType()) && !this.hasInterface(interfaceType, checkedInterfaces)) continue;
            return true;
        }
        return false;
    }

    private static Iterable<TypeDefinition> safeGetInterfaces(TypeDefinition typeDefinition) {
        return new SafeInterfaceIterator(typeDefinition);
    }

    static TypeDefinition safeGetSuperClass(TypeDefinition typeDefinition) {
        try {
            return typeDefinition.getSuperClass();
        }
        catch (Throwable e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "{0} trying to get super class for target {1}: {2}", new Object[]{e.getClass().getSimpleName(), Utils.safeTypeDefinitionName(typeDefinition), e.getMessage()});
            }
            return null;
        }
    }

    public String toString() {
        return "safeHasSuperType(" + this.matcher + ")";
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SafeHasSuperTypeMatcher)) {
            return false;
        }
        SafeHasSuperTypeMatcher other = (SafeHasSuperTypeMatcher)obj;
        return this.matcher.equals(other.matcher);
    }

    public int hashCode() {
        return this.matcher.hashCode();
    }

    @Override
    public ElementMatcher<?> getDelegate() {
        return this.matcher;
    }

    private static class SafeInterfaceIterator
    implements Iterator<TypeDefinition>,
    Iterable<TypeDefinition> {
        private final TypeDefinition typeDefinition;
        @Nullable
        private final Iterator<TypeDescription.Generic> it;
        private TypeDefinition next;

        private SafeInterfaceIterator(TypeDefinition typeDefinition) {
            this.typeDefinition = typeDefinition;
            Iterator it = null;
            try {
                it = typeDefinition.getInterfaces().iterator();
            }
            catch (Throwable e) {
                SafeInterfaceIterator.logException(typeDefinition, e);
            }
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            if (null != this.it && this.it.hasNext()) {
                try {
                    this.next = (TypeDefinition)this.it.next();
                    return true;
                }
                catch (Throwable e) {
                    SafeInterfaceIterator.logException(this.typeDefinition, e);
                    return false;
                }
            }
            return false;
        }

        @Override
        public TypeDefinition next() {
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<TypeDefinition> iterator() {
            return this;
        }

        private static void logException(TypeDefinition typeDefinition, Throwable e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "{0} trying to get interfaces for target {1}: {2}", new Object[]{e.getClass().getSimpleName(), Utils.safeTypeDefinitionName(typeDefinition), e.getMessage()});
            }
        }
    }
}

