/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import io.opentelemetry.javaagent.bootstrap.ExceptionLogger;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;

public class IndyBootstrapDispatcher {
    private static volatile MethodHandle bootstrap;

    private IndyBootstrapDispatcher() {
    }

    public static void init(MethodHandle bootstrapMethod) {
        bootstrap = bootstrapMethod;
    }

    public static CallSite bootstrap(MethodHandles.Lookup lookup, String adviceMethodName, MethodType adviceMethodType, Object ... args) {
        CallSite callSite = null;
        if (bootstrap != null) {
            try {
                callSite = bootstrap.invoke(lookup, adviceMethodName, adviceMethodType, args);
            }
            catch (Throwable e) {
                ExceptionLogger.logSuppressedError("Error bootstrapping indy instruction", e);
            }
        }
        if (callSite == null) {
            MethodHandle noop = IndyBootstrapDispatcher.generateNoopMethodHandle(adviceMethodType);
            callSite = new ConstantCallSite(noop);
        }
        return callSite;
    }

    static MethodHandle generateNoopMethodHandle(MethodType methodType) {
        TypeDescriptor.OfField returnType = methodType.returnType();
        MethodHandle noopNoArg = returnType == Void.TYPE ? MethodHandles.constant(Void.class, null).asType(MethodType.methodType(Void.TYPE)) : MethodHandles.constant(returnType, IndyBootstrapDispatcher.getDefaultValue(returnType));
        return MethodHandles.dropArguments(noopNoArg, 0, methodType.parameterList());
    }

    private static Object getDefaultValue(Class<?> classOrPrimitive) {
        if (classOrPrimitive.isPrimitive()) {
            return Array.get(Array.newInstance(classOrPrimitive, 1), 0);
        }
        return null;
    }
}

