/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.tomcat.v10_0;

import com.google.auto.service.AutoService;
import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatServerHandlerInstrumentation;
import io.opentelemetry.javaagent.tooling.muzzle.InstrumentationModuleMuzzle;
import io.opentelemetry.javaagent.tooling.muzzle.VirtualFieldMappingsBuilder;
import io.opentelemetry.javaagent.tooling.muzzle.references.ClassRef;
import io.opentelemetry.javaagent.tooling.muzzle.references.Flag;
import io.opentelemetry.javaagent.tooling.muzzle.references.Source;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.matcher.ElementMatcher;
import org.objectweb.asm.Type;

@AutoService(value={InstrumentationModule.class})
public class Tomcat10InstrumentationModule
extends InstrumentationModule
implements InstrumentationModuleMuzzle {
    public Tomcat10InstrumentationModule() {
        super("tomcat", new String[]{"tomcat-10.0"});
    }

    public ElementMatcher.Junction<ClassLoader> classLoaderMatcher() {
        return AgentElementMatchers.hasClassesNamed((String[])new String[]{"jakarta.servlet.http.HttpServletRequest"}).and((ElementMatcher)AgentElementMatchers.hasClassesNamed((String[])new String[]{"org.apache.catalina.users.GenericUser"}).or((ElementMatcher)AgentElementMatchers.hasClassesNamed((String[])new String[]{"org.apache.catalina.webresources.Cache$EvictionOrder"})));
    }

    public List<TypeInstrumentation> typeInstrumentations() {
        String packageName = Tomcat10InstrumentationModule.class.getPackage().getName();
        return Collections.singletonList(new TomcatServerHandlerInstrumentation(packageName + ".Tomcat10ServerHandlerAdvice", packageName + ".Tomcat10AttachResponseAdvice"));
    }

    public Map getMuzzleReferences() {
        HashMap<String, ClassRef> hashMap = new HashMap<String, ClassRef>(23, 0.75f);
        hashMap.put("org.apache.coyote.Request", ClassRef.builder((String)"org.apache.coyote.Request").addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10AttachResponseAdvice", 24).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 37).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 52).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 58).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 63).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ServletEntityProvider", 22).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ServletEntityProvider", 14).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 25).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 31).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 38).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 44).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 50).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 77).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 87).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 97).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 98).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 104).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 105).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 111).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 112).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 118).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 119).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 21).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatRequestGetter", 19).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatRequestGetter", 24).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatRequestGetter", 29).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatRequestGetter", 14).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ServerHandlerAdvice", 29).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ServerHandlerAdvice", 33).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ServerHandlerAdvice", 49).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 37)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "setAttribute", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"Ljava/lang/Object;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ServletEntityProvider", 22)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getNote", Type.getType((String)"Ljava/lang/Object;"), new Type[]{Type.getType((String)"I")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 25)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "method", Type.getType((String)"Lorg/apache/tomcat/util/buf/MessageBytes;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 31)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "scheme", Type.getType((String)"Lorg/apache/tomcat/util/buf/MessageBytes;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 38)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "requestURI", Type.getType((String)"Lorg/apache/tomcat/util/buf/MessageBytes;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 44)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "queryString", Type.getType((String)"Lorg/apache/tomcat/util/buf/MessageBytes;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 50), new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatRequestGetter", 19), new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatRequestGetter", 29)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getMimeHeaders", Type.getType((String)"Lorg/apache/tomcat/util/http/MimeHeaders;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 77), new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 87)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "protocol", Type.getType((String)"Lorg/apache/tomcat/util/buf/MessageBytes;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 97), new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 104), new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 111), new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 118)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "action", Type.getType((String)"V"), new Type[]{Type.getType((String)"Lorg/apache/coyote/ActionCode;"), Type.getType((String)"Ljava/lang/Object;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 98)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "remoteAddr", Type.getType((String)"Lorg/apache/tomcat/util/buf/MessageBytes;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 105)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getRemotePort", Type.getType((String)"I"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 112)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "localAddr", Type.getType((String)"Lorg/apache/tomcat/util/buf/MessageBytes;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 119)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getLocalPort", Type.getType((String)"I"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatRequestGetter", 24)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getHeader", Type.getType((String)"Ljava/lang/String;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).build());
        hashMap.put("org.apache.coyote.Response", ClassRef.builder((String)"org.apache.coyote.Response").addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10AttachResponseAdvice", 24).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 64).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ServletEntityProvider", 33).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ServletEntityProvider", 14).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 66).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 71).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 21).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ServerHandlerAdvice", 49).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ResponseMutator", 18).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ResponseMutator", 11).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ServletEntityProvider", 33)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getNote", Type.getType((String)"Ljava/lang/Object;"), new Type[]{Type.getType((String)"I")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 66)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getStatus", Type.getType((String)"I"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 71)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getMimeHeaders", Type.getType((String)"Lorg/apache/tomcat/util/http/MimeHeaders;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ResponseMutator", 18)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "addHeader", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"Ljava/lang/String;")}).build());
        hashMap.put("org.apache.tomcat.util.buf.MessageBytes", ClassRef.builder((String)"org.apache.tomcat.util.buf.MessageBytes").addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 76).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 77).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 79).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 25).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 31).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 32).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 38).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 44).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 56).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 77).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 87).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 98).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 112).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 76)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getType", Type.getType((String)"I"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 77)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getByteChunk", Type.getType((String)"Lorg/apache/tomcat/util/buf/ByteChunk;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 79)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "toString", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 32)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "isNull", Type.getType((String)"Z"), new Type[0]).build());
        hashMap.put("org.apache.tomcat.util.buf.ByteChunk", ClassRef.builder((String)"org.apache.tomcat.util.buf.ByteChunk").addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 77).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper", 77)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "toString", Type.getType((String)"Ljava/lang/String;"), new Type[0]).build());
        hashMap.put("jakarta.servlet.http.HttpServletRequest", ClassRef.builder((String)"jakarta.servlet.http.HttpServletRequest").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 33).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 38).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 43).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 48).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 53).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 58).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 63).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 68).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 73).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 78).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 83).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 88).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 93).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 98).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 104).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 110).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 116).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 121).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 126).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 136).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 24).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ServletEntityProvider", 24).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ServletEntityProvider", 25).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ServletEntityProvider", 14).addFlag((Flag)Flag.ManifestationFlag.INTERFACE).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 33)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getContextPath", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 38)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getScheme", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 43)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getRequestURI", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 48)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getQueryString", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 53)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getAttribute", Type.getType((String)"Ljava/lang/Object;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 58)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "setAttribute", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"Ljava/lang/Object;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 63)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getProtocol", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 68)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getMethod", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 73)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getRemoteAddr", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 78)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getRemotePort", Type.getType((String)"I"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 83)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getLocalAddr", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 88)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getLocalPort", Type.getType((String)"I"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 93)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getHeader", Type.getType((String)"Ljava/lang/String;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 98)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getHeaders", Type.getType((String)"Ljava/util/Enumeration;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 104)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getHeaderNames", Type.getType((String)"Ljava/util/Enumeration;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 110)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getParameterValues", Type.getType((String)"[Ljava/lang/String;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 116)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getServletPath", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 121)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getPathInfo", Type.getType((String)"Ljava/lang/String;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 126)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getUserPrincipal", Type.getType((String)"Ljava/security/Principal;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 136)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getAsyncContext", Type.getType((String)"Ljakarta/servlet/AsyncContext;"), new Type[0]).build());
        hashMap.put("jakarta.servlet.http.HttpServletResponse", ClassRef.builder((String)"jakarta.servlet.http.HttpServletResponse").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 134).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 136).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 143).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 148).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 160).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 170).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 24).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ServletEntityProvider", 35).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ServletEntityProvider", 36).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ServletEntityProvider", 14).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 182).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 192).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 143)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getStatus", Type.getType((String)"I"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 148)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getHeaders", Type.getType((String)"Ljava/util/Collection;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 160)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "isCommitted", Type.getType((String)"Z"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 170)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "addHeader", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"Ljava/lang/String;")}).build());
        hashMap.put("jakarta.servlet.AsyncContext", ClassRef.builder((String)"jakarta.servlet.AsyncContext").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 136).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 137).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 187).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 198).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 199).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 137), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 199)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "addListener", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljakarta/servlet/AsyncListener;"), Type.getType((String)"Ljakarta/servlet/ServletRequest;"), Type.getType((String)"Ljakarta/servlet/ServletResponse;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 187)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getTimeout", Type.getType((String)"J"), new Type[0]).build());
        hashMap.put("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", ClassRef.builder((String)"io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 136).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 0).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 177).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 182).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 187).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 192).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 173).addFlag((Flag)Flag.MinimumVisibilityFlag.PACKAGE_OR_HIGHER).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addFlag((Flag)Flag.ManifestationFlag.NON_FINAL).addFlag((Flag)Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER).setSuperClassName("java.lang.Object").addInterfaceName("jakarta.servlet.AsyncListener").addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 177), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 182), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 187), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 192)}, new Flag[]{Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER, Flag.OwnershipFlag.NON_STATIC}, "listener", Type.getType((String)"Lio/opentelemetry/javaagent/instrumentation/servlet/ServletAsyncListener;"), true).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "onComplete", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljakarta/servlet/AsyncEvent;")}).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "onTimeout", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljakarta/servlet/AsyncEvent;")}).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "onError", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljakarta/servlet/AsyncEvent;")}).addMethod(new Source[0], new Flag[]{Flag.VisibilityFlag.PUBLIC, Flag.OwnershipFlag.NON_STATIC, Flag.ManifestationFlag.NON_FINAL}, "onStartAsync", Type.getType((String)"V"), new Type[]{Type.getType((String)"Ljakarta/servlet/AsyncEvent;")}).build());
        hashMap.put("jakarta.servlet.AsyncListener", ClassRef.builder((String)"jakarta.servlet.AsyncListener").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 137).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 0).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 199).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).build());
        hashMap.put("jakarta.servlet.ServletRequest", ClassRef.builder((String)"jakarta.servlet.ServletRequest").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 137).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 199).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).build());
        hashMap.put("jakarta.servlet.ServletResponse", ClassRef.builder((String)"jakarta.servlet.ServletResponse").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 137).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 182).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 192).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 199).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).build());
        hashMap.put("jakarta.servlet.ServletException", ClassRef.builder((String)"jakarta.servlet.ServletException").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor", 165).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).build());
        hashMap.put("jakarta.servlet.Servlet", ClassRef.builder((String)"jakarta.servlet.Servlet").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Singletons", 68).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Singletons", 70).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Singletons", 37).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).build());
        hashMap.put("jakarta.servlet.Filter", ClassRef.builder((String)"jakarta.servlet.Filter").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Singletons", 72).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Singletons", 39).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).build());
        hashMap.put("jakarta.servlet.AsyncEvent", ClassRef.builder((String)"jakarta.servlet.AsyncEvent").addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 182).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 187).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 192).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 198).addSource("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 199).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 182), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 192), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 199)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getSuppliedResponse", Type.getType((String)"Ljakarta/servlet/ServletResponse;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 187), new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 198)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getAsyncContext", Type.getType((String)"Ljakarta/servlet/AsyncContext;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 192)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getThrowable", Type.getType((String)"Ljava/lang/Throwable;"), new Type[0]).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener", 199)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getSuppliedRequest", Type.getType((String)"Ljakarta/servlet/ServletRequest;"), new Type[0]).build());
        hashMap.put("org.apache.tomcat.util.http.MimeHeaders", ClassRef.builder((String)"org.apache.tomcat.util.http.MimeHeaders").addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 50).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 51).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 56).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 57).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 71).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatRequestGetter", 19).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatRequestGetter", 29).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addFlag((Flag)Flag.ManifestationFlag.NON_INTERFACE).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 51), new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 57)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "findHeader", Type.getType((String)"I"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"I")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 56)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getValue", Type.getType((String)"Lorg/apache/tomcat/util/buf/MessageBytes;"), new Type[]{Type.getType((String)"I")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 71), new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatRequestGetter", 29)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "values", Type.getType((String)"Ljava/util/Enumeration;"), new Type[]{Type.getType((String)"Ljava/lang/String;")}).addMethod(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatRequestGetter", 19)}, new Flag[]{Flag.OwnershipFlag.NON_STATIC, Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "names", Type.getType((String)"Ljava/util/Enumeration;"), new Type[0]).build());
        hashMap.put("org.apache.coyote.ActionCode", ClassRef.builder((String)"org.apache.coyote.ActionCode").addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 97).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 104).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 111).addSource("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 118).addFlag((Flag)Flag.MinimumVisibilityFlag.PUBLIC).addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 97)}, new Flag[]{Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER, Flag.OwnershipFlag.STATIC}, "REQ_HOST_ADDR_ATTRIBUTE", Type.getType((String)"Lorg/apache/coyote/ActionCode;"), false).addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 104)}, new Flag[]{Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER, Flag.OwnershipFlag.STATIC}, "REQ_REMOTEPORT_ATTRIBUTE", Type.getType((String)"Lorg/apache/coyote/ActionCode;"), false).addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 111)}, new Flag[]{Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER, Flag.OwnershipFlag.STATIC}, "REQ_LOCAL_ADDR_ATTRIBUTE", Type.getType((String)"Lorg/apache/coyote/ActionCode;"), false).addField(new Source[]{new Source("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter", 118)}, new Flag[]{Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER, Flag.OwnershipFlag.STATIC}, "REQ_LOCALPORT_ATTRIBUTE", Type.getType((String)"Lorg/apache/coyote/ActionCode;"), false).build());
        return hashMap;
    }

    public List getMuzzleHelperClassNames() {
        ArrayList<String> arrayList = new ArrayList<String>(29);
        arrayList.add("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHelper");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10Singletons");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatServletEntityProvider");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatInstrumenterFactory");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Singletons");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletAccessor");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.BaseServletHelper");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletRequestContext");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletAsyncListener");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.AsyncRunnableWrapper");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletResponseContext");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$1");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor$Listener");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatHttpAttributesGetter");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.tomcat.common.TomcatRequestGetter");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletErrorCauseExtractor");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.snippet.OutputStreamSnippetInjectionHelper");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletInstrumenterBuilder");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.common.response.ResponseInstrumenterFactory");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletSpanNameProvider");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletRequestParametersExtractor");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletRequestGetter");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletAdditionalAttributesExtractor");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletHttpAttributesGetter");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ResponseMutator");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.tomcat.v10_0.Tomcat10ServletEntityProvider");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.v5_0.Servlet5Accessor");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.ServletHelper");
        arrayList.add("io.opentelemetry.javaagent.instrumentation.servlet.AsyncRequestCompletionListener");
        return arrayList;
    }

    public void registerMuzzleVirtualFields(VirtualFieldMappingsBuilder virtualFieldMappingsBuilder) {
        virtualFieldMappingsBuilder.register("jakarta.servlet.Servlet", "io.opentelemetry.javaagent.bootstrap.servlet.MappingResolver$Factory").register("jakarta.servlet.Filter", "io.opentelemetry.javaagent.bootstrap.servlet.MappingResolver$Factory");
    }
}

