/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet.common.service;

import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ServletAndFilterInstrumentation
implements TypeInstrumentation {
    private final String basePackageName;
    private final String adviceClassName;
    private final String servletInitAdviceClassName;
    private final String filterInitAdviceClassName;

    public ServletAndFilterInstrumentation(String basePackageName, String adviceClassName, String servletInitAdviceClassName, String filterInitAdviceClassName) {
        this.basePackageName = basePackageName;
        this.adviceClassName = adviceClassName;
        this.servletInitAdviceClassName = servletInitAdviceClassName;
        this.filterInitAdviceClassName = filterInitAdviceClassName;
    }

    public ServletAndFilterInstrumentation(String basePackageName, String adviceClassName) {
        this(basePackageName, adviceClassName, null, null);
    }

    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return AgentElementMatchers.hasClassesNamed((String[])new String[]{this.basePackageName + ".Servlet"});
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.namedOneOf((String[])new String[]{this.basePackageName + ".Filter", this.basePackageName + ".Servlet"}));
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.namedOneOf((String[])new String[]{"doFilter", "service"}).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)(this.basePackageName + ".ServletRequest")))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)(this.basePackageName + ".ServletResponse")))).and((ElementMatcher)ElementMatchers.isPublic()), this.adviceClassName);
        if (this.servletInitAdviceClassName != null) {
            transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"init").and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)(this.basePackageName + ".ServletConfig")))), this.servletInitAdviceClassName);
        }
        if (this.filterInitAdviceClassName != null) {
            transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"init").and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)(this.basePackageName + ".FilterConfig")))), this.filterInitAdviceClassName);
        }
    }
}

