/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet.common.response;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.incubator.semconv.util.ClassAndMethod;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;

public class HttpServletResponseAdviceHelper {
    public static StartResult startSpan(Instrumenter<ClassAndMethod, Void> instrumenter, Class<?> declaringClass, String methodName) {
        ClassAndMethod classAndMethod;
        Context parentContext = Java8BytecodeBridge.currentContext();
        if (Java8BytecodeBridge.spanFromContext((Context)parentContext).getSpanContext().isValid() && instrumenter.shouldStart(parentContext, (Object)(classAndMethod = ClassAndMethod.create(declaringClass, (String)methodName)))) {
            Context context = instrumenter.start(parentContext, (Object)classAndMethod);
            Scope scope = context.makeCurrent();
            return new StartResult(classAndMethod, context, scope);
        }
        return null;
    }

    public static void stopSpan(Instrumenter<ClassAndMethod, Void> instrumenter, Throwable throwable, Context context, Scope scope, ClassAndMethod request) {
        if (scope != null) {
            scope.close();
            instrumenter.end(context, (Object)request, null, throwable);
        }
    }

    private HttpServletResponseAdviceHelper() {
    }

    public static final class StartResult {
        private final ClassAndMethod classAndMethod;
        private final Context context;
        private final Scope scope;

        private StartResult(ClassAndMethod classAndMethod, Context context, Scope scope) {
            this.classAndMethod = classAndMethod;
            this.context = context;
            this.scope = scope;
        }

        public ClassAndMethod getClassAndMethod() {
            return this.classAndMethod;
        }

        public Context getContext() {
            return this.context;
        }

        public Scope getScope() {
            return this.scope;
        }
    }
}

