/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.servlet;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.bootstrap.internal.AgentInstrumentationConfig;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletAccessor;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletRequestContext;
import io.opentelemetry.javaagent.instrumentation.servlet.ServletResponseContext;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public class ServletRequestParametersExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<ServletRequestContext<REQUEST>, ServletResponseContext<RESPONSE>> {
    private static final List<String> CAPTURE_REQUEST_PARAMETERS = AgentInstrumentationConfig.get().getList("otel.instrumentation.servlet.experimental.capture-request-parameters", Collections.emptyList());
    private static final ConcurrentMap<String, AttributeKey<List<String>>> parameterKeysCache = new ConcurrentHashMap<String, AttributeKey<List<String>>>();
    private final ServletAccessor<REQUEST, RESPONSE> accessor;

    public ServletRequestParametersExtractor(ServletAccessor<REQUEST, RESPONSE> accessor) {
        this.accessor = accessor;
    }

    public static boolean enabled() {
        return !CAPTURE_REQUEST_PARAMETERS.isEmpty();
    }

    public void setAttributes(REQUEST request, BiConsumer<AttributeKey<List<String>>, List<String>> consumer) {
        for (String name : CAPTURE_REQUEST_PARAMETERS) {
            List<String> values = this.accessor.getRequestParameterValues(request, name);
            if (values.isEmpty()) continue;
            consumer.accept(ServletRequestParametersExtractor.parameterAttributeKey(name), values);
        }
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, ServletRequestContext<REQUEST> requestContext) {
    }

    public void onEnd(AttributesBuilder attributes, Context context, ServletRequestContext<REQUEST> requestContext, @Nullable ServletResponseContext<RESPONSE> responseContext, @Nullable Throwable error) {
        REQUEST request = requestContext.request();
        this.setAttributes(request, (arg_0, arg_1) -> ((AttributesBuilder)attributes).put(arg_0, arg_1));
    }

    private static AttributeKey<List<String>> parameterAttributeKey(String headerName) {
        return parameterKeysCache.computeIfAbsent(headerName, ServletRequestParametersExtractor::createKey);
    }

    private static AttributeKey<List<String>> createKey(String parameterName) {
        parameterName = parameterName.toLowerCase(Locale.ROOT);
        String key = "servlet.request.parameter." + parameterName;
        return AttributeKey.stringArrayKey((String)key);
    }
}

