/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.scalaexecutors;

import io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.instrumentation.api.ContextStore;
import io.opentelemetry.javaagent.instrumentation.api.InstrumentationContext;
import io.opentelemetry.javaagent.instrumentation.api.Java8BytecodeBridge;
import io.opentelemetry.javaagent.instrumentation.api.concurrent.ExecutorInstrumentationUtils;
import io.opentelemetry.javaagent.instrumentation.api.concurrent.State;
import io.opentelemetry.javaagent.tooling.TypeInstrumentation;
import java.util.HashMap;
import java.util.Map;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import scala.concurrent.forkjoin.ForkJoinTask;

public class ScalaForkJoinPoolInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"scala.concurrent.forkjoin.ForkJoinPool");
    }

    public Map<? extends ElementMatcher<? super MethodDescription>, String> transformers() {
        HashMap<ElementMatcher.Junction, String> transformers = new HashMap<ElementMatcher.Junction, String>();
        transformers.put(ElementMatchers.named((String)"execute").and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"scala.concurrent.forkjoin.ForkJoinTask"))), ScalaForkJoinPoolInstrumentation.class.getName() + "$SetScalaForkJoinStateAdvice");
        transformers.put(ElementMatchers.named((String)"submit").and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"scala.concurrent.forkjoin.ForkJoinTask"))), ScalaForkJoinPoolInstrumentation.class.getName() + "$SetScalaForkJoinStateAdvice");
        transformers.put(ElementMatchers.nameMatches((String)"invoke").and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"scala.concurrent.forkjoin.ForkJoinTask"))), ScalaForkJoinPoolInstrumentation.class.getName() + "$SetScalaForkJoinStateAdvice");
        return transformers;
    }

    public static class SetScalaForkJoinStateAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static State enterJobSubmit(@Advice.Argument(value=0, readOnly=false) ForkJoinTask<?> task) {
            if (ExecutorInstrumentationUtils.shouldAttachStateToTask(task)) {
                ContextStore contextStore = InstrumentationContext.get(ForkJoinTask.class, State.class);
                return ExecutorInstrumentationUtils.setupState((ContextStore)contextStore, task, (Context)Java8BytecodeBridge.currentContext());
            }
            return null;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void exitJobSubmit(@Advice.Enter State state, @Advice.Thrown Throwable throwable) {
            ExecutorInstrumentationUtils.cleanUpOnMethodExit((State)state, (Throwable)throwable);
        }
    }
}

