/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.scalaexecutors;

import io.opentelemetry.javaagent.instrumentation.api.ContextStore;
import io.opentelemetry.javaagent.instrumentation.api.InstrumentationContext;
import io.opentelemetry.javaagent.instrumentation.api.concurrent.AdviceUtils;
import io.opentelemetry.javaagent.instrumentation.api.concurrent.State;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.tooling.TypeInstrumentation;
import io.opentelemetry.javaagent.tooling.bytebuddy.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.tooling.bytebuddy.matcher.ClassLoaderMatcher;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import scala.concurrent.forkjoin.ForkJoinTask;

public class ScalaForkJoinTaskInstrumentation
implements TypeInstrumentation {
    static final String TASK_CLASS_NAME = "scala.concurrent.forkjoin.ForkJoinTask";

    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return ClassLoaderMatcher.hasClassesNamed((String[])new String[]{TASK_CLASS_NAME});
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.extendsClass((ElementMatcher)ElementMatchers.named((String)TASK_CLASS_NAME));
    }

    public Map<? extends ElementMatcher<? super MethodDescription>, String> transformers() {
        return Collections.singletonMap(ElementMatchers.named((String)"exec").and((ElementMatcher)ElementMatchers.takesArguments((int)0)).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract())), ScalaForkJoinTaskInstrumentation.class.getName() + "$ForkJoinTaskAdvice");
    }

    public static class ForkJoinTaskAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Scope enter(@Advice.This ForkJoinTask<?> thiz) {
            ContextStore callableContextStore;
            ContextStore runnableContextStore;
            Scope newScope;
            ContextStore contextStore = InstrumentationContext.get(ForkJoinTask.class, State.class);
            Scope scope = AdviceUtils.startTaskScope((ContextStore)contextStore, thiz);
            if (thiz instanceof Runnable && null != (newScope = AdviceUtils.startTaskScope((ContextStore)(runnableContextStore = InstrumentationContext.get(Runnable.class, State.class)), (Object)((Runnable)thiz)))) {
                if (null != scope) {
                    newScope.close();
                } else {
                    scope = newScope;
                }
            }
            if (thiz instanceof Callable && null != (newScope = AdviceUtils.startTaskScope((ContextStore)(callableContextStore = InstrumentationContext.get(Callable.class, State.class)), (Object)((Callable)thiz)))) {
                if (null != scope) {
                    newScope.close();
                } else {
                    scope = newScope;
                }
            }
            return scope;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void exit(@Advice.Enter Scope scope) {
            if (scope != null) {
                scope.close();
            }
        }
    }
}

