/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.jdbc;

import io.opentelemetry.javaagent.instrumentation.api.Java8BytecodeBridge;
import io.opentelemetry.javaagent.instrumentation.jdbc.JdbcTracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.tooling.TypeInstrumentation;
import io.opentelemetry.javaagent.tooling.bytebuddy.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.tooling.bytebuddy.matcher.ClassLoaderMatcher;
import java.sql.PreparedStatement;
import java.util.Collections;
import java.util.Map;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class PreparedStatementInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return ClassLoaderMatcher.hasClassesNamed((String[])new String[]{"java.sql.PreparedStatement"});
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.implementsInterface((ElementMatcher)ElementMatchers.named((String)"java.sql.PreparedStatement"));
    }

    public Map<? extends ElementMatcher<? super MethodDescription>, String> transformers() {
        return Collections.singletonMap(ElementMatchers.nameStartsWith((String)"execute").and((ElementMatcher)ElementMatchers.takesArguments((int)0)).and((ElementMatcher)ElementMatchers.isPublic()), PreparedStatementInstrumentation.class.getName() + "$PreparedStatementAdvice");
    }

    public static class PreparedStatementAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.This PreparedStatement statement, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            if (!JdbcTracer.tracer().shouldStartSpan(parentContext)) {
                return;
            }
            context = JdbcTracer.tracer().startSpan(parentContext, statement);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void stopSpan(@Advice.Thrown Throwable throwable, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            scope.close();
            if (throwable == null) {
                JdbcTracer.tracer().end(context);
            } else {
                JdbcTracer.tracer().endExceptionally(context, throwable);
            }
        }
    }
}

