/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.jdbc;

import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.Statement;

public abstract class JdbcUtils {
    private static final Logger log = LoggerFactory.getLogger(JdbcUtils.class);
    private static Field c3poField = null;

    public static Connection connectionFromStatement(Statement statement) {
        Connection connection;
        try {
            connection = statement.getConnection();
            if (c3poField != null && connection.getClass().getName().equals("com.mchange.v2.c3p0.impl.NewProxyConnection")) {
                return (Connection)c3poField.get(connection);
            }
            try {
                if (connection.isWrapperFor(Connection.class)) {
                    connection = connection.unwrap(Connection.class);
                }
            }
            catch (AbstractMethodError | Exception e) {
                Class<?> connectionClass;
                if (connection != null && (connectionClass = connection.getClass()).getName().equals("com.mchange.v2.c3p0.impl.NewProxyConnection")) {
                    Field inner = connectionClass.getDeclaredField("inner");
                    inner.setAccessible(true);
                    c3poField = inner;
                    return (Connection)c3poField.get(connection);
                }
            }
        }
        catch (Throwable e) {
            log.debug("Could not get connection for StatementAdvice", e);
            return null;
        }
        return connection;
    }
}

