/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.jdbc;

import io.opentelemetry.javaagent.instrumentation.api.db.SqlStatementInfo;
import io.opentelemetry.javaagent.instrumentation.api.db.SqlStatementSanitizer;
import io.opentelemetry.javaagent.instrumentation.jdbc.DbInfo;
import io.opentelemetry.javaagent.instrumentation.jdbc.JdbcConnectionUrlParser;
import io.opentelemetry.javaagent.instrumentation.jdbc.JdbcMaps;
import io.opentelemetry.javaagent.instrumentation.jdbc.JdbcUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.DatabaseClientTracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class JdbcTracer
extends DatabaseClientTracer<DbInfo, String, SqlStatementInfo> {
    private static final JdbcTracer TRACER = new JdbcTracer();

    public static JdbcTracer tracer() {
        return TRACER;
    }

    protected String getInstrumentationName() {
        return "io.opentelemetry.javaagent.jdbc";
    }

    public Context startSpan(Context parentContext, PreparedStatement statement) {
        return this.startSpan(parentContext, statement, (String)JdbcMaps.preparedStatements.get((Object)statement));
    }

    public Context startSpan(Context parentContext, Statement statement, String query) {
        Connection connection = JdbcUtils.connectionFromStatement(statement);
        if (connection == null) {
            return null;
        }
        DbInfo dbInfo = this.extractDbInfo(connection);
        return this.startSpan(parentContext, dbInfo, query);
    }

    protected SqlStatementInfo sanitizeStatement(String statement) {
        return SqlStatementSanitizer.sanitize((String)statement);
    }

    protected String spanName(DbInfo connection, String statement, SqlStatementInfo sanitizedStatement) {
        return JdbcTracer.conventionSpanName((String)this.dbName(connection), (String)sanitizedStatement.getOperation(), (String)sanitizedStatement.getTable());
    }

    protected String dbSystem(DbInfo info) {
        return info.getSystem();
    }

    protected String dbUser(DbInfo info) {
        return info.getUser();
    }

    protected String dbName(DbInfo info) {
        if (info.getName() != null) {
            return info.getName();
        }
        return info.getDb();
    }

    protected String dbConnectionString(DbInfo info) {
        return info.getShortUrl();
    }

    protected InetSocketAddress peerAddress(DbInfo dbInfo) {
        return null;
    }

    protected void onStatement(SpanBuilder span, DbInfo connection, String statement, SqlStatementInfo sanitizedStatement) {
        super.onStatement(span, (Object)connection, (Object)statement, (Object)sanitizedStatement);
        String table = sanitizedStatement.getTable();
        if (table != null) {
            span.setAttribute(SemanticAttributes.DB_SQL_TABLE, (Object)table);
        }
    }

    protected String dbStatement(DbInfo connection, String statement, SqlStatementInfo sanitizedStatement) {
        return sanitizedStatement.getFullStatement();
    }

    protected String dbOperation(DbInfo connection, String statement, SqlStatementInfo sanitizedStatement) {
        return sanitizedStatement.getOperation();
    }

    private DbInfo extractDbInfo(Connection connection) {
        DbInfo dbInfo = (DbInfo)JdbcMaps.connectionInfo.get((Object)connection);
        if (dbInfo == null) {
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                String url = metaData.getURL();
                if (url != null) {
                    try {
                        dbInfo = JdbcConnectionUrlParser.parse(url, connection.getClientInfo());
                    }
                    catch (Throwable ex) {
                        dbInfo = JdbcConnectionUrlParser.parse(url, null);
                    }
                } else {
                    dbInfo = DbInfo.DEFAULT;
                }
            }
            catch (SQLException se) {
                dbInfo = DbInfo.DEFAULT;
            }
            JdbcMaps.connectionInfo.put((Object)connection, (Object)dbInfo);
        }
        return dbInfo;
    }
}

