/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.jdbc;

import com.google.auto.service.AutoService;
import io.opentelemetry.javaagent.instrumentation.api.Java8BytecodeBridge;
import io.opentelemetry.javaagent.instrumentation.jdbc.DataSourceTracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.tooling.InstrumentationModule;
import io.opentelemetry.javaagent.tooling.TypeInstrumentation;
import io.opentelemetry.javaagent.tooling.bytebuddy.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.tooling.muzzle.Reference;
import io.opentelemetry.javaagent.tooling.muzzle.matcher.ReferenceMatcher;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

@AutoService(value={InstrumentationModule.class})
public class JdbcDataSourceInstrumentationModule
extends InstrumentationModule {
    private volatile ReferenceMatcher muzzleReferenceMatcher = null;

    public JdbcDataSourceInstrumentationModule() {
        super("jdbc-datasource", new String[0]);
    }

    public List<TypeInstrumentation> typeInstrumentations() {
        return Collections.singletonList(new DataSourceInstrumentation());
    }

    public boolean defaultEnabled() {
        return false;
    }

    protected String[] getMuzzleHelperClassNames() {
        return new String[]{"io.opentelemetry.javaagent.instrumentation.jdbc.DataSourceTracer"};
    }

    protected synchronized ReferenceMatcher getMuzzleReferenceMatcher() {
        if (null == this.muzzleReferenceMatcher) {
            this.muzzleReferenceMatcher = new ReferenceMatcher(this.getAllHelperClassNames(), new Reference[]{new Reference.Builder("io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span").withSource("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 65).withFlag((Reference.Flag)Reference.Flag.MinimumVisibilityFlag.PUBLIC).withFlag((Reference.Flag)Reference.Flag.ManifestationFlag.INTERFACE).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 65)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.NON_STATIC, Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "getSpanContext", Type.getType((String)"Lio/opentelemetry/javaagent/shaded/io/opentelemetry/api/trace/SpanContext;"), new Type[0]).build(), new Reference.Builder("io.opentelemetry.javaagent.instrumentation.api.Java8BytecodeBridge").withSource("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 65).withFlag((Reference.Flag)Reference.Flag.ManifestationFlag.NON_INTERFACE).withFlag((Reference.Flag)Reference.Flag.MinimumVisibilityFlag.PUBLIC).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 65)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.STATIC, Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "currentSpan", Type.getType((String)"Lio/opentelemetry/javaagent/shaded/io/opentelemetry/api/trace/Span;"), new Type[0]).build(), new Reference.Builder("io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanContext").withSource("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 65).withFlag((Reference.Flag)Reference.Flag.MinimumVisibilityFlag.PUBLIC).withFlag((Reference.Flag)Reference.Flag.ManifestationFlag.INTERFACE).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 65)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.NON_STATIC, Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "isValid", Type.getType((String)"Z"), new Type[0]).build(), new Reference.Builder("io.opentelemetry.javaagent.instrumentation.jdbc.DataSourceTracer").withSource("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 70).withSource("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 85).withSource("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 87).withSource("io.opentelemetry.javaagent.instrumentation.jdbc.DataSourceTracer", 0).withSource("io.opentelemetry.javaagent.instrumentation.jdbc.DataSourceTracer", 14).withSource("io.opentelemetry.javaagent.instrumentation.jdbc.DataSourceTracer", 11).withFlag((Reference.Flag)Reference.Flag.MinimumVisibilityFlag.PACKAGE_OR_HIGHER).withFlag((Reference.Flag)Reference.Flag.ManifestationFlag.NON_INTERFACE).withFlag((Reference.Flag)Reference.Flag.ManifestationFlag.NON_FINAL).withFlag((Reference.Flag)Reference.Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER).withSuperName("io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.BaseTracer").withField(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.jdbc.DataSourceTracer", 14), new Reference.Source("io.opentelemetry.javaagent.instrumentation.jdbc.DataSourceTracer", 11)}, new Reference.Flag[]{Reference.Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER, Reference.Flag.OwnershipFlag.STATIC}, "TRACER", Type.getType((String)"Lio/opentelemetry/javaagent/instrumentation/jdbc/DataSourceTracer;")).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 70), new Reference.Source("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 85), new Reference.Source("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 87)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.STATIC, Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "tracer", Type.getType((String)"Lio/opentelemetry/javaagent/instrumentation/jdbc/DataSourceTracer;"), new Type[0]).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 70)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.NON_STATIC, Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "startSpan", Type.getType((String)"Lio/opentelemetry/javaagent/shaded/io/opentelemetry/context/Context;"), new Type[]{Type.getType((String)"Ljava/lang/String;"), Type.getType((String)"Lio/opentelemetry/javaagent/shaded/io/opentelemetry/api/trace/SpanKind;")}).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 85)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.NON_STATIC, Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "endExceptionally", Type.getType((String)"V"), new Type[]{Type.getType((String)"Lio/opentelemetry/javaagent/shaded/io/opentelemetry/context/Context;"), Type.getType((String)"Ljava/lang/Throwable;")}).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 87)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.NON_STATIC, Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "end", Type.getType((String)"V"), new Type[]{Type.getType((String)"Lio/opentelemetry/javaagent/shaded/io/opentelemetry/context/Context;")}).withMethod(new Reference.Source[0], new Reference.Flag[]{Reference.Flag.VisibilityFlag.PROTECTED, Reference.Flag.OwnershipFlag.NON_STATIC, Reference.Flag.ManifestationFlag.NON_FINAL}, "getInstrumentationName", Type.getType((String)"Ljava/lang/String;"), new Type[0]).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.jdbc.DataSourceTracer", 11)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.NON_STATIC, Reference.Flag.MinimumVisibilityFlag.PRIVATE_OR_HIGHER}, "<init>", Type.getType((String)"V"), new Type[0]).build(), new Reference.Builder("io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind").withSource("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 70).withFlag((Reference.Flag)Reference.Flag.MinimumVisibilityFlag.PUBLIC).withField(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 70)}, new Reference.Flag[]{Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER, Reference.Flag.OwnershipFlag.STATIC}, "CLIENT", Type.getType((String)"Lio/opentelemetry/javaagent/shaded/io/opentelemetry/api/trace/SpanKind;")).build(), new Reference.Builder("io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context").withSource("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 70).withSource("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 71).withSource("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 85).withSource("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 87).withFlag((Reference.Flag)Reference.Flag.MinimumVisibilityFlag.PUBLIC).withFlag((Reference.Flag)Reference.Flag.ManifestationFlag.INTERFACE).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 71)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.NON_STATIC, Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "makeCurrent", Type.getType((String)"Lio/opentelemetry/javaagent/shaded/io/opentelemetry/context/Scope;"), new Type[0]).build(), new Reference.Builder("io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Scope").withSource("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 71).withSource("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 82).withFlag((Reference.Flag)Reference.Flag.MinimumVisibilityFlag.PUBLIC).withFlag((Reference.Flag)Reference.Flag.ManifestationFlag.INTERFACE).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.jdbc.JdbcDataSourceInstrumentationModule$GetConnectionAdvice", 82)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.NON_STATIC, Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "close", Type.getType((String)"V"), new Type[0]).build(), new Reference.Builder("io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.BaseTracer").withSource("io.opentelemetry.javaagent.instrumentation.jdbc.DataSourceTracer", 0).withSource("io.opentelemetry.javaagent.instrumentation.jdbc.DataSourceTracer", 10).withFlag((Reference.Flag)Reference.Flag.ManifestationFlag.NON_INTERFACE).withFlag((Reference.Flag)Reference.Flag.MinimumVisibilityFlag.PUBLIC).withMethod(new Reference.Source[]{new Reference.Source("io.opentelemetry.javaagent.instrumentation.jdbc.DataSourceTracer", 10)}, new Reference.Flag[]{Reference.Flag.OwnershipFlag.NON_STATIC, Reference.Flag.MinimumVisibilityFlag.PROTECTED_OR_HIGHER}, "<init>", Type.getType((String)"V"), new Type[0]).build()});
        }
        return this.muzzleReferenceMatcher;
    }

    public static class GetConnectionAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void start(@Advice.This DataSource ds, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (!Java8BytecodeBridge.currentSpan().getSpanContext().isValid()) {
                return;
            }
            context = DataSourceTracer.tracer().startSpan(ds.getClass().getSimpleName() + ".getConnection", SpanKind.CLIENT);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void stopSpan(@Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope, @Advice.Thrown Throwable throwable) {
            if (scope == null) {
                return;
            }
            scope.close();
            if (throwable != null) {
                DataSourceTracer.tracer().endExceptionally(context, throwable);
            } else {
                DataSourceTracer.tracer().end(context);
            }
        }
    }

    public static class DataSourceInstrumentation
    implements TypeInstrumentation {
        public ElementMatcher<TypeDescription> typeMatcher() {
            return AgentElementMatchers.implementsInterface((ElementMatcher)ElementMatchers.named((String)"javax.sql.DataSource"));
        }

        public Map<? extends ElementMatcher<? super MethodDescription>, String> transformers() {
            return Collections.singletonMap(ElementMatchers.named((String)"getConnection"), GetConnectionAdvice.class.getName());
        }
    }
}

