/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.jdbc;

import io.opentelemetry.javaagent.instrumentation.jdbc.DbInfo;
import io.opentelemetry.javaagent.instrumentation.jdbc.JdbcConnectionUrlParser;
import io.opentelemetry.javaagent.instrumentation.jdbc.JdbcMaps;
import io.opentelemetry.javaagent.tooling.TypeInstrumentation;
import io.opentelemetry.javaagent.tooling.bytebuddy.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.tooling.bytebuddy.matcher.ClassLoaderMatcher;
import java.sql.Connection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class DriverInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return ClassLoaderMatcher.hasClassesNamed((String[])new String[]{"java.sql.Driver"});
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.implementsInterface((ElementMatcher)ElementMatchers.named((String)"java.sql.Driver"));
    }

    public Map<? extends ElementMatcher<? super MethodDescription>, String> transformers() {
        return Collections.singletonMap(ElementMatchers.nameStartsWith((String)"connect").and((ElementMatcher)ElementMatchers.takesArgument((int)0, String.class)).and((ElementMatcher)ElementMatchers.takesArgument((int)1, Properties.class)).and((ElementMatcher)ElementMatchers.returns((ElementMatcher)ElementMatchers.named((String)"java.sql.Connection"))), DriverInstrumentation.class.getName() + "$DriverAdvice");
    }

    public static class DriverAdvice {
        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void addDbInfo(@Advice.Argument(value=0) String url, @Advice.Argument(value=1) Properties props, @Advice.Return Connection connection) {
            if (connection == null) {
                return;
            }
            DbInfo dbInfo = JdbcConnectionUrlParser.parse(url, props);
            JdbcMaps.connectionInfo.put((Object)connection, (Object)dbInfo);
        }
    }
}

