/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.jdbc;

import java.util.Objects;

public class DbInfo {
    public static final DbInfo DEFAULT = new Builder().build();
    private final String system;
    private final String subtype;
    private final String shortUrl;
    private final String user;
    private final String name;
    private final String db;
    private final String host;
    private final Integer port;

    public DbInfo(String system, String subtype, String shortUrl, String user, String name, String db, String host, Integer port) {
        this.system = system;
        this.subtype = subtype;
        this.shortUrl = shortUrl;
        this.user = user;
        this.name = name;
        this.db = db;
        this.host = host;
        this.port = port;
    }

    public String getSystem() {
        return this.system;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getShortUrl() {
        return this.shortUrl;
    }

    public String getUser() {
        return this.user;
    }

    public String getName() {
        return this.name;
    }

    public String getDb() {
        return this.db;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public Builder toBuilder() {
        return new Builder().system(this.system).subtype(this.subtype).shortUrl(this.shortUrl).user(this.user).name(this.name).db(this.db).host(this.host).port(this.port);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DbInfo)) {
            return false;
        }
        DbInfo other = (DbInfo)obj;
        return Objects.equals(this.system, other.system) && Objects.equals(this.subtype, other.subtype) && Objects.equals(this.shortUrl, other.shortUrl) && Objects.equals(this.user, other.user) && Objects.equals(this.name, other.name) && Objects.equals(this.db, other.db) && Objects.equals(this.host, other.host) && Objects.equals(this.port, other.port);
    }

    public int hashCode() {
        return Objects.hash(this.system, this.subtype, this.shortUrl, this.user, this.name, this.db, this.host, this.port);
    }

    public static class Builder {
        private String system;
        private String subtype;
        private String shortUrl;
        private String user;
        private String name;
        private String db;
        private String host;
        private Integer port;

        public Builder system(String system) {
            this.system = system;
            return this;
        }

        public Builder subtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        public Builder shortUrl(String shortUrl) {
            this.shortUrl = shortUrl;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public DbInfo build() {
            return new DbInfo(this.system, this.subtype, this.shortUrl, this.user, this.name, this.db, this.host, this.port);
        }
    }
}

