/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.jdbc;

import io.opentelemetry.javaagent.instrumentation.jdbc.JdbcMaps;
import io.opentelemetry.javaagent.tooling.TypeInstrumentation;
import io.opentelemetry.javaagent.tooling.bytebuddy.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.tooling.bytebuddy.matcher.ClassLoaderMatcher;
import java.sql.PreparedStatement;
import java.util.Collections;
import java.util.Map;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ConnectionInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return ClassLoaderMatcher.hasClassesNamed((String[])new String[]{"java.sql.Connection"});
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.implementsInterface((ElementMatcher)ElementMatchers.named((String)"java.sql.Connection"));
    }

    public Map<? extends ElementMatcher<? super MethodDescription>, String> transformers() {
        return Collections.singletonMap(ElementMatchers.nameStartsWith((String)"prepare").and((ElementMatcher)ElementMatchers.takesArgument((int)0, String.class)).and((ElementMatcher)ElementMatchers.returns((ElementMatcher)AgentElementMatchers.hasInterface((ElementMatcher)ElementMatchers.named((String)"java.sql.PreparedStatement")))), ConnectionInstrumentation.class.getName() + "$ConnectionPrepareAdvice");
    }

    public static class ConnectionPrepareAdvice {
        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void addDbInfo(@Advice.Argument(value=0) String sql, @Advice.Return PreparedStatement statement) {
            JdbcMaps.preparedStatements.put((Object)statement, (Object)sql);
        }
    }
}

