/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.log4j.appender.v1_2;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.logs.LogRecordBuilder;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.internal.cache.Cache;
import io.opentelemetry.javaagent.bootstrap.internal.InstrumentationConfig;
import io.opentelemetry.semconv.SemanticAttributes;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Category;
import org.apache.log4j.MDC;
import org.apache.log4j.Priority;

public final class LogEventMapper {
    private static final Cache<String, AttributeKey<String>> mdcAttributeKeys = Cache.bounded((int)100);
    public static final LogEventMapper INSTANCE = new LogEventMapper();
    private static final int TRACE_INT = 5000;
    private static final boolean captureExperimentalAttributes = InstrumentationConfig.get().getBoolean("otel.instrumentation.log4j-appender.experimental-log-attributes", false);
    private final Map<String, AttributeKey<String>> captureMdcAttributes;
    private final boolean captureAllMdcAttributes;

    private LogEventMapper() {
        List captureMdcAttributes = InstrumentationConfig.get().getList("otel.instrumentation.log4j-appender.experimental.capture-mdc-attributes", Collections.emptyList());
        this.captureMdcAttributes = captureMdcAttributes.stream().collect(Collectors.toMap(attr -> attr, LogEventMapper::getMdcAttributeKey));
        this.captureAllMdcAttributes = captureMdcAttributes.size() == 1 && ((String)captureMdcAttributes.get(0)).equals("*");
    }

    public void capture(Category logger, Priority level, Object message, Throwable throwable) {
        String instrumentationName = logger.getName();
        if (instrumentationName == null || instrumentationName.isEmpty()) {
            instrumentationName = "ROOT";
        }
        LogRecordBuilder builder = GlobalOpenTelemetry.get().getLogsBridge().loggerBuilder(instrumentationName).build().logRecordBuilder();
        if (message != null) {
            builder.setBody(String.valueOf(message));
        }
        if (level != null) {
            builder.setSeverity(LogEventMapper.levelToSeverity(level));
            builder.setSeverityText(level.toString());
        }
        AttributesBuilder attributes = Attributes.builder();
        if (throwable != null) {
            attributes.put(SemanticAttributes.EXCEPTION_TYPE, (Object)throwable.getClass().getName());
            attributes.put(SemanticAttributes.EXCEPTION_MESSAGE, (Object)throwable.getMessage());
            StringWriter writer = new StringWriter();
            throwable.printStackTrace(new PrintWriter(writer));
            attributes.put(SemanticAttributes.EXCEPTION_STACKTRACE, (Object)writer.toString());
        }
        this.captureMdcAttributes(attributes);
        if (captureExperimentalAttributes) {
            Thread currentThread = Thread.currentThread();
            attributes.put(SemanticAttributes.THREAD_NAME, (Object)currentThread.getName());
            attributes.put(SemanticAttributes.THREAD_ID, (Object)currentThread.getId());
        }
        builder.setAllAttributes(attributes.build());
        builder.setContext(Context.current());
        builder.setTimestamp(Instant.now());
        builder.emit();
    }

    private void captureMdcAttributes(AttributesBuilder attributes) {
        Hashtable context = MDC.getContext();
        if (this.captureAllMdcAttributes) {
            if (context != null) {
                for (Map.Entry entry : context.entrySet()) {
                    attributes.put(LogEventMapper.getMdcAttributeKey(String.valueOf(entry.getKey())), (Object)String.valueOf(entry.getValue()));
                }
            }
            return;
        }
        for (Map.Entry<String, AttributeKey<String>> entry : this.captureMdcAttributes.entrySet()) {
            Object value = context.get(entry.getKey());
            if (value == null) continue;
            attributes.put(entry.getValue(), (Object)value.toString());
        }
    }

    private static AttributeKey<String> getMdcAttributeKey(String key) {
        return (AttributeKey)mdcAttributeKeys.computeIfAbsent((Object)key, k -> AttributeKey.stringKey((String)("log4j.mdc." + k)));
    }

    private static Severity levelToSeverity(Priority level) {
        int lev = level.toInt();
        if (lev <= 5000) {
            return Severity.TRACE;
        }
        if (lev <= 10000) {
            return Severity.DEBUG;
        }
        if (lev <= 20000) {
            return Severity.INFO;
        }
        if (lev <= 30000) {
            return Severity.WARN;
        }
        if (lev <= 40000) {
            return Severity.ERROR;
        }
        return Severity.FATAL;
    }
}

