/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.jetty.httpclient.v9_2;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.jetty.httpclient.v9_2.internal.JettyClientWrapUtil;
import io.opentelemetry.instrumentation.jetty.httpclient.v9_2.internal.JettyHttpClient9TracingInterceptor;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.jetty.httpclient.v9_2.JettyHttpClientSingletons;
import java.util.List;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;

public class JettyHttpClient9Instrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"org.eclipse.jetty.client.HttpClient");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"send")).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.eclipse.jetty.client.HttpRequest"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, List.class)), JettyHttpClient9Instrumentation.class.getName() + "$JettyHttpClient9Advice");
    }

    public static class JettyHttpClient9Advice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void addTracingEnter(@Advice.Argument(value=0) HttpRequest httpRequest, @Advice.Argument(value=1, readOnly=false) List<Response.ResponseListener> listeners, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            if (!JettyHttpClientSingletons.instrumenter().shouldStart(parentContext, (Object)httpRequest)) {
                return;
            }
            JettyHttpClient9TracingInterceptor requestInterceptor = new JettyHttpClient9TracingInterceptor(parentContext, JettyHttpClientSingletons.instrumenter());
            requestInterceptor.attachToRequest((Request)httpRequest);
            listeners = JettyClientWrapUtil.wrapResponseListeners((Context)parentContext, listeners);
            context = requestInterceptor.getContext();
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void exitTracingInterceptor(@Advice.Argument(value=0) HttpRequest httpRequest, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            scope.close();
            if (throwable != null) {
                JettyHttpClientSingletons.instrumenter().end(context, (Object)httpRequest, null, throwable);
            }
        }
    }
}

