/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.jedis.v4_0;

import com.google.auto.value.AutoValue;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.RedisCommandSanitizer;
import io.opentelemetry.javaagent.bootstrap.internal.AgentCommonConfig;
import io.opentelemetry.javaagent.instrumentation.jedis.v4_0.AutoValue_JedisRequest;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.args.Rawable;
import redis.clients.jedis.commands.ProtocolCommand;

@AutoValue
public abstract class JedisRequest {
    private static final RedisCommandSanitizer sanitizer = RedisCommandSanitizer.create((boolean)AgentCommonConfig.get().isStatementSanitizationEnabled());
    private SocketAddress remoteSocketAddress;

    public static JedisRequest create(ProtocolCommand command, List<byte[]> args) {
        return new AutoValue_JedisRequest(command, args);
    }

    public static JedisRequest create(CommandArguments commandArguments) {
        ProtocolCommand command = commandArguments.getCommand();
        ArrayList<byte[]> arguments = new ArrayList<byte[]>();
        boolean first = true;
        for (Rawable rawable : commandArguments) {
            if (first) {
                first = false;
                continue;
            }
            arguments.add(rawable.getRaw());
        }
        return JedisRequest.create(command, arguments);
    }

    public abstract ProtocolCommand getCommand();

    public abstract List<byte[]> getArgs();

    public String getOperation() {
        ProtocolCommand command = this.getCommand();
        if (command instanceof Protocol.Command) {
            return ((Protocol.Command)command).name();
        }
        return new String(command.getRaw(), StandardCharsets.UTF_8);
    }

    public String getStatement() {
        return sanitizer.sanitize(this.getOperation(), this.getArgs());
    }

    public void setSocket(Socket socket) {
        if (socket != null) {
            this.remoteSocketAddress = socket.getRemoteSocketAddress();
        }
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.remoteSocketAddress;
    }
}

