/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.jedis.v4_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.jedis.JedisRequestContext;
import io.opentelemetry.javaagent.instrumentation.jedis.v4_0.JedisRequest;
import io.opentelemetry.javaagent.instrumentation.jedis.v4_0.JedisSingletons;
import java.net.Socket;
import java.util.Arrays;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.commands.ProtocolCommand;

public class JedisConnectionInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"redis.clients.jedis.Connection");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"sendCommand")).and((ElementMatcher)ElementMatchers.takesArguments((int)1)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"redis.clients.jedis.CommandArguments"))), this.getClass().getName() + "$SendCommand2Advice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"sendCommand")).and((ElementMatcher)ElementMatchers.takesArguments((int)2)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"redis.clients.jedis.commands.ProtocolCommand"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.is(byte[][].class))), this.getClass().getName() + "$SendCommandAdvice");
    }

    public static class SendCommand2Advice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.Argument(value=0) CommandArguments command, @Advice.Local(value="otelJedisRequest") JedisRequest request, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            request = JedisRequest.create(command);
            if (!JedisSingletons.instrumenter().shouldStart(parentContext, (Object)request)) {
                return;
            }
            context = JedisSingletons.instrumenter().start(parentContext, (Object)request);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void stopSpan(@Advice.FieldValue(value="socket") Socket socket, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelJedisRequest") JedisRequest request, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            request.setSocket(socket);
            scope.close();
            JedisRequestContext.endIfNotAttached(JedisSingletons.instrumenter(), (Context)context, (Object)request, (Throwable)throwable);
        }
    }

    public static class SendCommandAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.Argument(value=0) ProtocolCommand command, @Advice.Argument(value=1) byte[][] args, @Advice.Local(value="otelJedisRequest") JedisRequest request, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            request = JedisRequest.create(command, Arrays.asList(args));
            if (!JedisSingletons.instrumenter().shouldStart(parentContext, (Object)request)) {
                return;
            }
            context = JedisSingletons.instrumenter().start(parentContext, (Object)request);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void stopSpan(@Advice.FieldValue(value="socket") Socket socket, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelJedisRequest") JedisRequest request, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            request.setSocket(socket);
            scope.close();
            JedisRequestContext.endIfNotAttached(JedisSingletons.instrumenter(), (Context)context, (Object)request, (Throwable)throwable);
        }
    }
}

