/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.jedis.v3_0;

import com.google.auto.value.AutoValue;
import io.opentelemetry.instrumentation.api.db.RedisCommandSanitizer;
import io.opentelemetry.javaagent.instrumentation.jedis.v3_0.AutoValue_JedisRequest;
import java.nio.charset.StandardCharsets;
import java.util.List;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;

@AutoValue
public abstract class JedisRequest {
    public static JedisRequest create(Connection connection, ProtocolCommand command, List<byte[]> args) {
        return new AutoValue_JedisRequest(connection, command, args);
    }

    public abstract Connection getConnection();

    public abstract ProtocolCommand getCommand();

    public abstract List<byte[]> getArgs();

    public String getOperation() {
        ProtocolCommand command = this.getCommand();
        if (command instanceof Protocol.Command) {
            return ((Protocol.Command)command).name();
        }
        return new String(command.getRaw(), StandardCharsets.UTF_8);
    }

    public String getStatement() {
        return RedisCommandSanitizer.sanitize((String)this.getOperation(), this.getArgs());
    }
}

