/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.jedis.v3_0;

import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.jedis.JedisRequestContext;
import io.opentelemetry.javaagent.instrumentation.jedis.v3_0.JedisRequest;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class JedisInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.namedOneOf((String[])new String[]{"redis.clients.jedis.Jedis", "redis.clients.jedis.BinaryJedis"});
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.isPublic()).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isStatic())).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.namedOneOf((String[])new String[]{"close", "setDataSource", "getDB", "isConnected", "connect", "resetState", "getClient", "disconnect", "getConnection", "isConnected", "isBroken", "toString"}))), this.getClass().getName() + "$JedisMethodAdvice");
    }

    public static class JedisMethodAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static JedisRequestContext<JedisRequest> onEnter() {
            return JedisRequestContext.attach();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Enter JedisRequestContext<JedisRequest> requestContext) {
            if (requestContext != null) {
                requestContext.detachAndEnd();
            }
        }
    }
}

