/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.jul;

import application.java.util.logging.Logger;
import io.opentelemetry.instrumentation.api.appender.internal.LogEmitterProvider;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.instrumentation.api.CallDepth;
import io.opentelemetry.javaagent.instrumentation.jul.JavaUtilLoggingHelper;
import java.util.logging.LogRecord;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

class JavaUtilLoggingInstrumentation
implements TypeInstrumentation {
    JavaUtilLoggingInstrumentation() {
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.extendsClass((ElementMatcher)ElementMatchers.named((String)"application.java.util.logging.Logger"));
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.isPublic()).and((ElementMatcher)ElementMatchers.named((String)"log")).and((ElementMatcher)ElementMatchers.takesArguments((int)1)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"java.util.logging.LogRecord"))), JavaUtilLoggingInstrumentation.class.getName() + "$LogAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.isPublic()).and((ElementMatcher)ElementMatchers.named((String)"logRaw")).and((ElementMatcher)ElementMatchers.takesArguments((int)1)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.jboss.logmanager.ExtLogRecord"))), JavaUtilLoggingInstrumentation.class.getName() + "$LogAdvice");
    }

    public static class LogAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void methodEnter(@Advice.This Logger logger, @Advice.Argument(value=0) LogRecord logRecord, @Advice.Local(value="otelCallDepth") CallDepth callDepth) {
            callDepth = CallDepth.forClass(LogEmitterProvider.class);
            if (callDepth.getAndIncrement() == 0) {
                JavaUtilLoggingHelper.capture(logger, logRecord);
            }
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.Local(value="otelCallDepth") CallDepth callDepth) {
            callDepth.decrementAndGet();
        }
    }
}

