/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.jul;

import application.java.util.logging.Logger;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.appender.internal.LogBuilder;
import io.opentelemetry.instrumentation.api.appender.internal.Severity;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.instrumentation.api.appender.internal.AgentLogEmitterProvider;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.TimeUnit;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public final class JavaUtilLoggingHelper {
    private static final Formatter FORMATTER = new AccessibleFormatter();
    private static final boolean captureExperimentalAttributes = Config.get().getBoolean("otel.instrumentation.java-util-logging.experimental-log-attributes", false);

    public static void capture(Logger logger, LogRecord logRecord) {
        if (!logger.isLoggable(logRecord.getLevel())) {
            return;
        }
        String instrumentationName = logger.getName();
        if (instrumentationName == null || instrumentationName.isEmpty()) {
            instrumentationName = "ROOT";
        }
        LogBuilder builder = AgentLogEmitterProvider.get().logEmitterBuilder(instrumentationName).build().logBuilder();
        JavaUtilLoggingHelper.mapLogRecord(builder, logRecord);
        builder.emit();
    }

    private static void mapLogRecord(LogBuilder builder, LogRecord logRecord) {
        String message = FORMATTER.formatMessage(logRecord);
        if (message != null) {
            builder.setBody(message);
        }
        long timestamp = logRecord.getMillis();
        builder.setEpoch(timestamp, TimeUnit.MILLISECONDS);
        Level level = logRecord.getLevel();
        if (level != null) {
            builder.setSeverity(JavaUtilLoggingHelper.levelToSeverity(level));
            builder.setSeverityText(logRecord.getLevel().getName());
        }
        AttributesBuilder attributes = Attributes.builder();
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            attributes.put(SemanticAttributes.EXCEPTION_TYPE, (Object)throwable.getClass().getName());
            attributes.put(SemanticAttributes.EXCEPTION_MESSAGE, (Object)throwable.getMessage());
            StringWriter writer = new StringWriter();
            throwable.printStackTrace(new PrintWriter(writer));
            attributes.put(SemanticAttributes.EXCEPTION_STACKTRACE, (Object)writer.toString());
        }
        if (captureExperimentalAttributes) {
            Thread currentThread = Thread.currentThread();
            attributes.put(SemanticAttributes.THREAD_NAME, (Object)currentThread.getName());
            attributes.put(SemanticAttributes.THREAD_ID, (Object)currentThread.getId());
        }
        builder.setAttributes(attributes.build());
        builder.setContext(Context.current());
    }

    private static Severity levelToSeverity(Level level) {
        int lev = level.intValue();
        if (lev <= Level.FINEST.intValue()) {
            return Severity.TRACE;
        }
        if (lev <= Level.FINER.intValue()) {
            return Severity.DEBUG;
        }
        if (lev <= Level.FINE.intValue()) {
            return Severity.DEBUG2;
        }
        if (lev <= Level.CONFIG.intValue()) {
            return Severity.DEBUG3;
        }
        if (lev <= Level.INFO.intValue()) {
            return Severity.INFO;
        }
        if (lev <= Level.WARNING.intValue()) {
            return Severity.WARN;
        }
        if (lev <= Level.SEVERE.intValue()) {
            return Severity.ERROR;
        }
        return Severity.FATAL;
    }

    private JavaUtilLoggingHelper() {
    }

    private static class AccessibleFormatter
    extends Formatter {
        private AccessibleFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            throw new UnsupportedOperationException();
        }
    }
}

