/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.httpclient;

import io.opentelemetry.javaagent.instrumentation.api.Java8BytecodeBridge;
import io.opentelemetry.javaagent.instrumentation.httpclient.JdkHttpClientTracer;
import io.opentelemetry.javaagent.tooling.TypeInstrumentation;
import io.opentelemetry.javaagent.tooling.bytebuddy.matcher.AgentElementMatchers;
import java.net.http.HttpHeaders;
import java.util.Collections;
import java.util.Map;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class HttpHeadersInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.nameStartsWith((String)"java.net.").or((ElementMatcher)ElementMatchers.nameStartsWith((String)"jdk.internal.")).and((ElementMatcher)AgentElementMatchers.extendsClass((ElementMatcher)ElementMatchers.named((String)"java.net.http.HttpRequest")));
    }

    public Map<? extends ElementMatcher<? super MethodDescription>, String> transformers() {
        return Collections.singletonMap(ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"headers")), HttpHeadersInstrumentation.class.getName() + "$HeadersAdvice");
    }

    public static class HeadersAdvice {
        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.Return(readOnly=false) HttpHeaders headers) {
            if (Java8BytecodeBridge.currentSpan().isRecording()) {
                headers = JdkHttpClientTracer.tracer().inject(headers);
            }
        }
    }
}

