/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.httpclient;

import io.opentelemetry.javaagent.instrumentation.httpclient.HttpHeadersInjectAdapter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.HttpClientTracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletionException;

public class JdkHttpClientTracer
extends HttpClientTracer<HttpRequest, HttpRequest, HttpResponse<?>> {
    private static final JdkHttpClientTracer TRACER = new JdkHttpClientTracer();

    public static JdkHttpClientTracer tracer() {
        return TRACER;
    }

    protected String getInstrumentationName() {
        return "io.opentelemetry.javaagent.java-httpclient";
    }

    protected String method(HttpRequest httpRequest) {
        return httpRequest.method();
    }

    protected URI url(HttpRequest httpRequest) {
        return httpRequest.uri();
    }

    protected Integer status(HttpResponse<?> httpResponse) {
        return httpResponse.statusCode();
    }

    protected String requestHeader(HttpRequest httpRequest, String name) {
        return httpRequest.headers().firstValue(name).orElse(null);
    }

    protected String responseHeader(HttpResponse<?> httpResponse, String name) {
        return httpResponse.headers().firstValue(name).orElse(null);
    }

    protected void onResponse(Span span, HttpResponse<?> httpResponse) {
        super.onResponse(span, httpResponse);
        if (httpResponse != null) {
            span.setAttribute(SemanticAttributes.HTTP_FLAVOR, (Object)(httpResponse.version() == HttpClient.Version.HTTP_1_1 ? "1.1" : "2.0"));
        }
    }

    protected TextMapPropagator.Setter<HttpRequest> getSetter() {
        return HttpHeadersInjectAdapter.SETTER;
    }

    protected Throwable unwrapThrowable(Throwable throwable) {
        if (throwable instanceof CompletionException) {
            return throwable.getCause();
        }
        return super.unwrapThrowable(throwable);
    }

    public HttpHeaders inject(HttpHeaders original) {
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        GlobalOpenTelemetry.getPropagators().getTextMapPropagator().inject(Context.current(), headerMap, (carrier, key, value) -> carrier.put(key, Collections.singletonList(value)));
        headerMap.putAll(original.map());
        return HttpHeaders.of(headerMap, (s, s2) -> true);
    }
}

