/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.httpclient;

import io.opentelemetry.javaagent.instrumentation.api.Java8BytecodeBridge;
import io.opentelemetry.javaagent.instrumentation.httpclient.JdkHttpClientTracer;
import io.opentelemetry.javaagent.instrumentation.httpclient.ResponseConsumer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.tooling.TypeInstrumentation;
import io.opentelemetry.javaagent.tooling.bytebuddy.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.tooling.bytebuddy.matcher.ClassLoaderMatcher;
import java.lang.invoke.CallSite;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class HttpClientInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return ClassLoaderMatcher.hasClassesNamed((String[])new String[]{"java.net.http.HttpClient"});
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.nameStartsWith((String)"java.net.").or((ElementMatcher)ElementMatchers.nameStartsWith((String)"jdk.internal.")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.named((String)"jdk.internal.net.http.HttpClientFacade"))).and((ElementMatcher)AgentElementMatchers.extendsClass((ElementMatcher)ElementMatchers.named((String)"java.net.http.HttpClient")));
    }

    public Map<? extends ElementMatcher<? super MethodDescription>, String> transformers() {
        HashMap<ElementMatcher.Junction, CallSite> transformers = new HashMap<ElementMatcher.Junction, CallSite>();
        transformers.put(ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"send")).and((ElementMatcher)ElementMatchers.isPublic()).and((ElementMatcher)ElementMatchers.takesArguments((int)2)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"java.net.http.HttpRequest"))), (CallSite)((Object)(HttpClientInstrumentation.class.getName() + "$SendAdvice")));
        transformers.put(ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)"sendAsync")).and((ElementMatcher)ElementMatchers.isPublic()).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"java.net.http.HttpRequest"))), (CallSite)((Object)(HttpClientInstrumentation.class.getName() + "$SendAsyncAdvice")));
        return transformers;
    }

    public static class SendAsyncAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void methodEnter(@Advice.Argument(value=0) HttpRequest httpRequest, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            if (!JdkHttpClientTracer.tracer().shouldStartSpan(parentContext)) {
                return;
            }
            context = JdkHttpClientTracer.tracer().startSpan(parentContext, httpRequest, httpRequest);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.Return(readOnly=false) CompletableFuture<HttpResponse<?>> future, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            scope.close();
            if (throwable != null) {
                JdkHttpClientTracer.tracer().endExceptionally(context, null, throwable);
            } else {
                future = future.whenComplete((BiConsumer)new ResponseConsumer(context));
            }
        }
    }

    public static class SendAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void methodEnter(@Advice.Argument(value=0) HttpRequest httpRequest, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            if (!JdkHttpClientTracer.tracer().shouldStartSpan(parentContext)) {
                return;
            }
            context = JdkHttpClientTracer.tracer().startSpan(parentContext, httpRequest, httpRequest);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.Return HttpResponse<?> result, @Advice.Thrown Throwable throwable, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            if (scope == null) {
                return;
            }
            scope.close();
            if (throwable == null) {
                JdkHttpClientTracer.tracer().end(context, result);
            } else {
                JdkHttpClientTracer.tracer().endExceptionally(context, result, throwable);
            }
        }
    }
}

