/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.guava.v10_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.bootstrap.executors.ExecutorAdviceHelper;
import io.opentelemetry.javaagent.bootstrap.executors.PropagatedContext;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.guava.v10_0.InstrumentationHelper;
import java.util.concurrent.Executor;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class GuavaListenableFutureInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"com.google.common.util.concurrent.AbstractFuture");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isConstructor(), this.getClass().getName() + "$AbstractFutureAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"addListener").and((ElementMatcher)ElementMatchers.takesArguments((Class[])new Class[]{Runnable.class, Executor.class})), this.getClass().getName() + "$AddListenerAdvice");
    }

    public static class AddListenerAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static PropagatedContext addListenerEnter(@Advice.Argument(value=0) Runnable task) {
            Context context = Java8BytecodeBridge.currentContext();
            if (ExecutorAdviceHelper.shouldPropagateContext((Context)context, (Object)task)) {
                VirtualField virtualField = VirtualField.find(Runnable.class, PropagatedContext.class);
                return ExecutorAdviceHelper.attachContextToTask((Context)context, (VirtualField)virtualField, (Object)task);
            }
            return null;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void addListenerExit(@Advice.Enter PropagatedContext propagatedContext, @Advice.Thrown Throwable throwable) {
            ExecutorAdviceHelper.cleanUpAfterSubmit((PropagatedContext)propagatedContext, (Throwable)throwable);
        }
    }

    public static class AbstractFutureAdvice {
        @Advice.OnMethodExit(suppress=Throwable.class)
        public static void onConstruction() {
            InstrumentationHelper.initialize();
        }
    }
}

