/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.extannotations;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.util.ClassAndMethod;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.bootstrap.internal.InstrumentationConfig;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.instrumentation.extannotations.ExternalAnnotationInstrumentationModule;
import io.opentelemetry.javaagent.instrumentation.extannotations.ExternalAnnotationSingletons;
import io.opentelemetry.javaagent.tooling.config.MethodsConfigurationParser;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ExternalAnnotationInstrumentation
implements TypeInstrumentation {
    private static final Logger logger = Logger.getLogger(ExternalAnnotationInstrumentationModule.class.getName());
    private static final String PACKAGE_CLASS_NAME_REGEX = "[\\w.$]+";
    static final String CONFIG_FORMAT = "(?:\\s*[\\w.$]+\\s*;)*\\s*[\\w.$]+\\s*;?\\s*";
    private static final List<String> DEFAULT_ANNOTATIONS = Arrays.asList("com.appoptics.api.ext.LogMethod", "com.newrelic.api.agent.Trace", "com.signalfx.tracing.api.Trace", "com.tracelytics.api.ext.LogMethod", "datadog.trace.api.Trace", "io.opentracing.contrib.dropwizard.Trace", "kamon.annotation.Trace", "kamon.annotation.api.Trace", "org.springframework.cloud.sleuth.annotation.NewSpan");
    private static final String TRACE_ANNOTATIONS_CONFIG = "otel.instrumentation.external-annotations.include";
    private static final String TRACE_ANNOTATED_METHODS_EXCLUDE_CONFIG = "otel.instrumentation.external-annotations.exclude-methods";
    private final ElementMatcher.Junction<ClassLoader> classLoaderOptimization;
    private final ElementMatcher.Junction<NamedElement> traceAnnotationMatcher;
    private final ElementMatcher.Junction<MethodDescription> excludedMethodsMatcher;

    public ExternalAnnotationInstrumentation() {
        Set<String> additionalTraceAnnotations = ExternalAnnotationInstrumentation.configureAdditionalTraceAnnotations(InstrumentationConfig.get());
        if (additionalTraceAnnotations.isEmpty()) {
            this.classLoaderOptimization = ElementMatchers.none();
            this.traceAnnotationMatcher = ElementMatchers.none();
        } else {
            ElementMatcher.Junction classLoaderMatcher = ElementMatchers.none();
            for (String annotationName : additionalTraceAnnotations) {
                classLoaderMatcher = classLoaderMatcher.or((ElementMatcher)AgentElementMatchers.hasClassesNamed((String[])new String[]{annotationName}));
            }
            this.classLoaderOptimization = classLoaderMatcher;
            this.traceAnnotationMatcher = ElementMatchers.namedOneOf((String[])additionalTraceAnnotations.toArray(new String[0]));
        }
        this.excludedMethodsMatcher = ExternalAnnotationInstrumentation.configureExcludedMethods();
    }

    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return this.classLoaderOptimization;
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.declaresMethod((ElementMatcher)ElementMatchers.isAnnotatedWith(this.traceAnnotationMatcher));
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isAnnotatedWith(this.traceAnnotationMatcher).and((ElementMatcher)ElementMatchers.not(this.excludedMethodsMatcher)), ExternalAnnotationInstrumentation.class.getName() + "$ExternalAnnotationAdvice");
    }

    private static Set<String> configureAdditionalTraceAnnotations(InstrumentationConfig config) {
        String[] annotationClasses;
        String configString = config.getString(TRACE_ANNOTATIONS_CONFIG);
        if (configString == null) {
            return Collections.unmodifiableSet(new HashSet<String>(DEFAULT_ANNOTATIONS));
        }
        if (configString.isEmpty()) {
            return Collections.emptySet();
        }
        if (!configString.matches(CONFIG_FORMAT)) {
            logger.log(Level.WARNING, "Invalid trace annotations config \"{0}\". Must match 'package.Annotation$Name;*'.", configString);
            return Collections.emptySet();
        }
        HashSet<String> annotations = new HashSet<String>();
        for (String annotationClass : annotationClasses = configString.split(";", -1)) {
            if (annotationClass.trim().isEmpty()) continue;
            annotations.add(annotationClass.trim());
        }
        return Collections.unmodifiableSet(annotations);
    }

    private static ElementMatcher.Junction<MethodDescription> configureExcludedMethods() {
        ElementMatcher.Junction result = ElementMatchers.none();
        Map excludedMethods = MethodsConfigurationParser.parse((String)InstrumentationConfig.get().getString(TRACE_ANNOTATED_METHODS_EXCLUDE_CONFIG));
        for (Map.Entry entry : excludedMethods.entrySet()) {
            String className = (String)entry.getKey();
            ElementMatcher.Junction classMather = ElementMatchers.isDeclaredBy((ElementMatcher)ElementMatchers.named((String)className));
            ElementMatcher.Junction excludedMethodsMatcher = ElementMatchers.none();
            for (String methodName : (Set)entry.getValue()) {
                excludedMethodsMatcher = excludedMethodsMatcher.or((ElementMatcher)ElementMatchers.named((String)methodName));
            }
            result = result.or((ElementMatcher)classMather.and((ElementMatcher)excludedMethodsMatcher));
        }
        return result;
    }

    public static class ExternalAnnotationAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.Origin(value="#t") Class<?> declaringClass, @Advice.Origin(value="#m") String methodName, @Advice.Local(value="otelRequest") ClassAndMethod request, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            request = ClassAndMethod.create(declaringClass, (String)methodName);
            if (!ExternalAnnotationSingletons.instrumenter().shouldStart(parentContext, (Object)request)) {
                return;
            }
            context = ExternalAnnotationSingletons.instrumenter().start(parentContext, (Object)request);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void stopSpan(@Advice.Local(value="otelRequest") ClassAndMethod request, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope, @Advice.Thrown Throwable throwable) {
            if (scope == null) {
                return;
            }
            scope.close();
            ExternalAnnotationSingletons.instrumenter().end(context, (Object)request, null, throwable);
        }
    }
}

