/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.elasticsearch.rest.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.elasticsearch.rest.internal.ElasticsearchRestRequest;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;

public final class RestResponseListener
implements ResponseListener {
    private final ResponseListener listener;
    private final Context parentContext;
    private final Instrumenter<ElasticsearchRestRequest, Response> instrumenter;
    private final Context context;
    private final ElasticsearchRestRequest request;

    public RestResponseListener(ResponseListener listener, Context parentContext, Instrumenter<ElasticsearchRestRequest, Response> instrumenter, Context context, ElasticsearchRestRequest request) {
        this.listener = listener;
        this.parentContext = parentContext;
        this.instrumenter = instrumenter;
        this.context = context;
        this.request = request;
    }

    public void onSuccess(Response response) {
        this.instrumenter.end(this.context, (Object)this.request, (Object)response, null);
        try (Scope ignored = this.parentContext.makeCurrent();){
            this.listener.onSuccess(response);
        }
    }

    public void onFailure(Exception e) {
        this.instrumenter.end(this.context, (Object)this.request, null, (Throwable)e);
        try (Scope ignored = this.parentContext.makeCurrent();){
            this.listener.onFailure(e);
        }
    }
}

