/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.elasticsearch.rest.internal;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.DbClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.DbClientAttributesGetter;
import io.opentelemetry.instrumentation.elasticsearch.rest.internal.ElasticsearchClientAttributeExtractor;
import io.opentelemetry.instrumentation.elasticsearch.rest.internal.ElasticsearchDbAttributesGetter;
import io.opentelemetry.instrumentation.elasticsearch.rest.internal.ElasticsearchRestRequest;
import io.opentelemetry.instrumentation.elasticsearch.rest.internal.ElasticsearchSpanNameExtractor;
import java.util.List;
import java.util.Set;
import org.elasticsearch.client.Response;

public final class ElasticsearchRestInstrumenterFactory {
    private ElasticsearchRestInstrumenterFactory() {
    }

    public static Instrumenter<ElasticsearchRestRequest, Response> create(OpenTelemetry openTelemetry, String instrumentationName, List<AttributesExtractor<ElasticsearchRestRequest, Response>> attributesExtractors, Set<String> knownMethods, boolean captureSearchQuery) {
        ElasticsearchDbAttributesGetter dbClientAttributesGetter = new ElasticsearchDbAttributesGetter(captureSearchQuery);
        ElasticsearchClientAttributeExtractor esClientAtrributesExtractor = new ElasticsearchClientAttributeExtractor(knownMethods);
        ElasticsearchSpanNameExtractor nameExtractor = new ElasticsearchSpanNameExtractor(dbClientAttributesGetter);
        return Instrumenter.builder((OpenTelemetry)openTelemetry, (String)instrumentationName, (SpanNameExtractor)nameExtractor).addAttributesExtractor(DbClientAttributesExtractor.create((DbClientAttributesGetter)dbClientAttributesGetter)).addAttributesExtractor((AttributesExtractor)esClientAtrributesExtractor).addAttributesExtractors(attributesExtractors).buildInstrumenter(SpanKindExtractor.alwaysClient());
    }
}

