/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.elasticsearch.rest.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class ElasticsearchEndpointDefinition {
    private static final String UNDERSCORE_REPLACEMENT = "0";
    private final String endpointName;
    private final List<Route> routes;
    private final boolean isSearchEndpoint;

    public ElasticsearchEndpointDefinition(String endpointName, String[] routes, boolean isSearchEndpoint) {
        this.endpointName = endpointName;
        this.routes = Collections.unmodifiableList(Arrays.stream(routes).map(Route::new).collect(Collectors.toList()));
        this.isSearchEndpoint = isSearchEndpoint;
    }

    @Nullable
    public String getEndpointName() {
        return this.endpointName;
    }

    public boolean isSearchEndpoint() {
        return this.isSearchEndpoint;
    }

    public void processPathParts(String urlPath, BiConsumer<String, String> consumer) {
        for (Route route : this.routes) {
            Matcher matcher;
            if (!route.hasParameters() || !(matcher = route.createMatcher(urlPath)).find()) continue;
            for (String key : route.getPathPartNames()) {
                String value = matcher.group(key);
                if (key.contains(UNDERSCORE_REPLACEMENT)) {
                    key = key.replace(UNDERSCORE_REPLACEMENT, "_");
                }
                consumer.accept(key, value);
            }
            return;
        }
    }

    public List<Route> getRoutes() {
        return this.routes;
    }

    public static final class Route {
        private final String name;
        private final boolean hasParameters;
        private volatile EndpointPattern epPattern;

        public Route(String name) {
            this.name = name;
            this.hasParameters = name.contains("{") && name.contains("}");
        }

        public String getName() {
            return this.name;
        }

        boolean hasParameters() {
            return this.hasParameters;
        }

        List<String> getPathPartNames() {
            return this.getEndpointPattern().getPathPartNames();
        }

        Matcher createMatcher(String urlPath) {
            return this.getEndpointPattern().getPattern().matcher(urlPath);
        }

        private EndpointPattern getEndpointPattern() {
            if (this.epPattern == null) {
                this.epPattern = new EndpointPattern(this);
            }
            return this.epPattern;
        }
    }

    public static final class EndpointPattern {
        private static final Pattern PATH_PART_NAMES_PATTERN = Pattern.compile("\\{([^}]+)}");
        private final Pattern pattern;
        private final List<String> pathPartNames;

        private EndpointPattern(Route route) {
            this.pattern = EndpointPattern.buildRegexPattern(route.getName());
            if (route.hasParameters()) {
                this.pathPartNames = new ArrayList<String>();
                Matcher matcher = PATH_PART_NAMES_PATTERN.matcher(route.getName());
                while (matcher.find()) {
                    String groupName = matcher.group(1);
                    if (groupName == null) continue;
                    groupName = groupName.replace("_", ElasticsearchEndpointDefinition.UNDERSCORE_REPLACEMENT);
                    this.pathPartNames.add(groupName);
                }
            } else {
                this.pathPartNames = Collections.emptyList();
            }
        }

        public static Pattern buildRegexPattern(String routeStr) {
            StringBuilder regexStr = new StringBuilder();
            regexStr.append('^');
            int startIdx = routeStr.indexOf("{");
            while (startIdx >= 0) {
                regexStr.append(routeStr.substring(0, startIdx));
                int endIndex = routeStr.indexOf("}");
                if (endIndex <= startIdx + 1) break;
                regexStr.append("(?<");
                regexStr.append(routeStr.substring(startIdx + 1, endIndex).replace("_", ElasticsearchEndpointDefinition.UNDERSCORE_REPLACEMENT));
                regexStr.append(">[^/]+)");
                routeStr = routeStr.substring(endIndex + 1);
                startIdx = routeStr.indexOf("{");
            }
            regexStr.append(routeStr);
            regexStr.append('$');
            return Pattern.compile(regexStr.toString());
        }

        Pattern getPattern() {
            return this.pattern;
        }

        List<String> getPathPartNames() {
            return this.pathPartNames;
        }
    }
}

