/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.elasticsearch.rest.internal;

import io.opentelemetry.instrumentation.api.instrumenter.db.DbClientAttributesGetter;
import io.opentelemetry.instrumentation.elasticsearch.rest.internal.ElasticsearchEndpointDefinition;
import io.opentelemetry.instrumentation.elasticsearch.rest.internal.ElasticsearchRestRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;

final class ElasticsearchDbAttributesGetter
implements DbClientAttributesGetter<ElasticsearchRestRequest> {
    private static final Logger logger = Logger.getLogger(ElasticsearchDbAttributesGetter.class.getName());
    private final boolean captureSearchQuery;

    ElasticsearchDbAttributesGetter(boolean captureSearchQuery) {
        this.captureSearchQuery = captureSearchQuery;
    }

    public String getSystem(ElasticsearchRestRequest request) {
        return "elasticsearch";
    }

    @Nullable
    public String getUser(ElasticsearchRestRequest request) {
        return null;
    }

    @Nullable
    public String getName(ElasticsearchRestRequest request) {
        return null;
    }

    @Nullable
    public String getConnectionString(ElasticsearchRestRequest request) {
        return null;
    }

    @Nullable
    public String getStatement(ElasticsearchRestRequest request) {
        ElasticsearchEndpointDefinition epDefinition = request.getEndpointDefinition();
        HttpEntity httpEntity = request.getHttpEntity();
        if (this.captureSearchQuery && epDefinition != null && epDefinition.isSearchEndpoint() && httpEntity != null && httpEntity.isRepeatable()) {
            try {
                return new BufferedReader(new InputStreamReader(httpEntity.getContent(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining());
            }
            catch (IOException e) {
                logger.log(Level.FINE, "Failed reading HTTP body content.", e);
            }
        }
        return null;
    }

    @Nullable
    public String getOperation(ElasticsearchRestRequest request) {
        ElasticsearchEndpointDefinition endpointDefinition = request.getEndpointDefinition();
        return endpointDefinition != null ? endpointDefinition.getEndpointName() : null;
    }
}

