/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.elasticsearch.rest.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.instrumentation.api.internal.cache.Cache;
import io.opentelemetry.instrumentation.elasticsearch.rest.internal.ElasticsearchEndpointDefinition;
import io.opentelemetry.instrumentation.elasticsearch.rest.internal.ElasticsearchRestRequest;
import io.opentelemetry.semconv.SemanticAttributes;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.http.HttpHost;
import org.elasticsearch.client.Response;

public class ElasticsearchClientAttributeExtractor
implements AttributesExtractor<ElasticsearchRestRequest, Response> {
    private static final String PATH_PARTS_ATTRIBUTE_PREFIX = "db.elasticsearch.path_parts.";
    private static final Cache<String, AttributeKey<String>> pathPartKeysCache = Cache.bounded((int)64);
    private final Set<String> knownMethods;

    ElasticsearchClientAttributeExtractor(Set<String> knownMethods) {
        this.knownMethods = new HashSet<String>(knownMethods);
    }

    private static void setServerAttributes(AttributesBuilder attributes, Response response) {
        HttpHost host = response.getHost();
        if (host != null) {
            if (SemconvStability.emitStableHttpSemconv()) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.SERVER_ADDRESS, (Object)host.getHostName());
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.SERVER_PORT, (Object)host.getPort());
            }
            if (SemconvStability.emitOldHttpSemconv()) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_PEER_NAME, (Object)host.getHostName());
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_PEER_PORT, (Object)host.getPort());
            }
        }
    }

    private static void setUrlAttribute(AttributesBuilder attributes, Response response) {
        String uri = response.getRequestLine().getUri();
        uri = uri.startsWith("/") ? uri : "/" + uri;
        String fullUrl = response.getHost().toURI() + uri;
        if (SemconvStability.emitStableHttpSemconv()) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.URL_FULL, (Object)fullUrl);
        }
        if (SemconvStability.emitOldHttpSemconv()) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_URL, (Object)fullUrl);
        }
    }

    private static void setPathPartsAttributes(AttributesBuilder attributes, ElasticsearchRestRequest request) {
        ElasticsearchEndpointDefinition endpointDef = request.getEndpointDefinition();
        if (endpointDef == null) {
            return;
        }
        endpointDef.processPathParts(request.getEndpoint(), (key, value) -> {
            AttributeKey attributeKey = (AttributeKey)pathPartKeysCache.computeIfAbsent(key, k -> AttributeKey.stringKey((String)(PATH_PARTS_ATTRIBUTE_PREFIX + k)));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)attributeKey, (Object)value);
        });
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, ElasticsearchRestRequest request) {
        String method = request.getMethod();
        if (SemconvStability.emitStableHttpSemconv()) {
            if (method == null || this.knownMethods.contains(method)) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_REQUEST_METHOD, (Object)method);
            } else {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_REQUEST_METHOD, (Object)"_OTHER");
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_REQUEST_METHOD_ORIGINAL, (Object)method);
            }
        }
        if (SemconvStability.emitOldHttpSemconv()) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_METHOD, (Object)method);
        }
        ElasticsearchClientAttributeExtractor.setPathPartsAttributes(attributes, request);
    }

    public void onEnd(AttributesBuilder attributes, Context context, ElasticsearchRestRequest request, @Nullable Response response, @Nullable Throwable error) {
        if (response != null) {
            ElasticsearchClientAttributeExtractor.setUrlAttribute(attributes, response);
            ElasticsearchClientAttributeExtractor.setServerAttributes(attributes, response);
        }
    }
}

