/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.apachehttpclient.v4_3;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolVersion;

public final class ApacheHttpClientRequest {
    private static final Logger logger = Logger.getLogger(ApacheHttpClientRequest.class.getName());
    @Nullable
    private final URI uri;
    private final HttpRequest delegate;
    @Nullable
    private final HttpHost target;

    ApacheHttpClientRequest(@Nullable HttpHost httpHost, HttpRequest httpRequest) {
        URI calculatedUri = ApacheHttpClientRequest.getUri(httpRequest);
        this.uri = calculatedUri != null && httpHost != null ? ApacheHttpClientRequest.getCalculatedUri(httpHost, calculatedUri) : calculatedUri;
        this.delegate = httpRequest;
        this.target = httpHost;
    }

    public HttpRequest getDelegate() {
        return this.delegate;
    }

    List<String> getHeader(String name) {
        return ApacheHttpClientRequest.headersToList(this.delegate.getHeaders(name));
    }

    static List<String> headersToList(Header[] headers) {
        if (headers.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> headersList = new ArrayList<String>(headers.length);
        for (int i = 0; i < headers.length; ++i) {
            headersList.add(headers[i].getValue());
        }
        return headersList;
    }

    void setHeader(String name, String value) {
        this.delegate.setHeader(name, value);
    }

    String getMethod() {
        return this.delegate.getRequestLine().getMethod();
    }

    @Nullable
    String getUrl() {
        return this.uri != null ? this.uri.toString() : null;
    }

    @Nullable
    String getFlavor() {
        ProtocolVersion protocolVersion = this.delegate.getProtocolVersion();
        String protocol = protocolVersion.getProtocol();
        if (!protocol.equals("HTTP")) {
            return null;
        }
        int major = protocolVersion.getMajor();
        int minor = protocolVersion.getMinor();
        if (major == 1 && minor == 0) {
            return "1.0";
        }
        if (major == 1 && minor == 1) {
            return "1.1";
        }
        if (major == 2 && minor == 0) {
            return "2.0";
        }
        logger.log(Level.FINE, "unexpected http protocol version: {0}", protocolVersion);
        return null;
    }

    @Nullable
    public String getPeerName() {
        return this.uri == null ? null : this.uri.getHost();
    }

    @Nullable
    public Integer getPeerPort() {
        return this.uri == null ? null : Integer.valueOf(this.uri.getPort());
    }

    @Nullable
    private static URI getUri(HttpRequest httpRequest) {
        try {
            return new URI(httpRequest.getRequestLine().getUri());
        }
        catch (URISyntaxException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return null;
        }
    }

    @Nullable
    private static URI getCalculatedUri(HttpHost httpHost, URI uri) {
        try {
            return new URI(httpHost.getSchemeName(), null, httpHost.getHostName(), httpHost.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return null;
        }
    }

    @Nullable
    public InetSocketAddress peerSocketAddress() {
        if (this.target == null) {
            return null;
        }
        InetAddress inetAddress = this.target.getAddress();
        return inetAddress == null ? null : new InetSocketAddress(inetAddress, this.target.getPort());
    }
}

