/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.apachehttpclient.v4_3;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApacheHttpClientRequest {
    private static final Logger logger = LoggerFactory.getLogger(ApacheHttpClientRequest.class);
    @Nullable
    private final URI uri;
    private final HttpRequest delegate;

    ApacheHttpClientRequest(@Nullable HttpHost httpHost, HttpRequest httpRequest) {
        URI calculatedUri = ApacheHttpClientRequest.getUri(httpRequest);
        this.uri = calculatedUri != null && httpHost != null ? ApacheHttpClientRequest.getCalculatedUri(httpHost, calculatedUri) : calculatedUri;
        this.delegate = httpRequest;
    }

    public HttpRequest getDelegate() {
        return this.delegate;
    }

    List<String> getHeader(String name) {
        return ApacheHttpClientRequest.headersToList(this.delegate.getHeaders(name));
    }

    static List<String> headersToList(Header[] headers) {
        if (headers.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> headersList = new ArrayList<String>(headers.length);
        for (int i = 0; i < headers.length; ++i) {
            headersList.add(headers[i].getValue());
        }
        return headersList;
    }

    void setHeader(String name, String value) {
        this.delegate.setHeader(name, value);
    }

    String getMethod() {
        return this.delegate.getRequestLine().getMethod();
    }

    @Nullable
    String getUrl() {
        return this.uri != null ? this.uri.toString() : null;
    }

    @Nullable
    String getFlavor() {
        ProtocolVersion protocolVersion = this.delegate.getProtocolVersion();
        String protocol = protocolVersion.getProtocol();
        if (!protocol.equals("HTTP")) {
            return null;
        }
        int major = protocolVersion.getMajor();
        int minor = protocolVersion.getMinor();
        if (major == 1 && minor == 0) {
            return "1.0";
        }
        if (major == 1 && minor == 1) {
            return "1.1";
        }
        if (major == 2 && minor == 0) {
            return "2.0";
        }
        logger.debug("unexpected http protocol version: {}", (Object)protocolVersion);
        return null;
    }

    @Nullable
    String getPeerName() {
        return this.uri != null ? this.uri.getHost() : null;
    }

    @Nullable
    Integer getPeerPort() {
        if (this.uri == null) {
            return null;
        }
        int port = this.uri.getPort();
        if (port != -1) {
            return port;
        }
        switch (this.uri.getScheme()) {
            case "http": {
                return 80;
            }
            case "https": {
                return 443;
            }
        }
        logger.debug("no default port mapping for scheme: {}", (Object)this.uri.getScheme());
        return null;
    }

    @Nullable
    private static URI getUri(HttpRequest httpRequest) {
        try {
            return new URI(httpRequest.getRequestLine().getUri());
        }
        catch (URISyntaxException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static URI getCalculatedUri(HttpHost httpHost, URI uri) {
        try {
            return new URI(httpHost.getSchemeName(), null, httpHost.getHostName(), httpHost.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

