/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.reporting;

import com.squareup.moshi.JsonWriter;
import io.objectbox.reporting.BuildPropertiesFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSink;
import org.greenrobot.essentials.hash.Murmur3F;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 52\u00020\u0001:\u00015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u001a\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u001e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\bJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J \u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\b\b\u0002\u0010 \u001a\u00020\bJ \u0010!\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\bJ\u0006\u0010\"\u001a\u00020\bJ\u001c\u0010#\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u001c\u0010$\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u001c\u0010%\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015J6\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u001bJ\u0006\u0010-\u001a\u00020\u0003J\n\u0010.\u001a\u0004\u0018\u00010\u0003H\u0014J\u0010\u0010/\u001a\u000200*\u000600j\u0002`1H\u0004J\u0018\u00102\u001a\u000200*\u000600j\u0002`12\u0006\u00103\u001a\u00020\u0003H\u0004J\u0018\u00103\u001a\u000200*\u000600j\u0002`12\u0006\u00103\u001a\u00020\u0003H\u0004J\u0018\u00104\u001a\u000200*\u000600j\u0002`12\u0006\u00103\u001a\u00020\u0003H\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lio/objectbox/reporting/BasicBuildTracker;", "", "toolName", "", "(Ljava/lang/String;)V", "buildPropertiesFile", "Lio/objectbox/reporting/BuildPropertiesFile;", "disconnect", "", "getDisconnect", "()Z", "setDisconnect", "(Z)V", "countBuild", "", "encodeBase64WithoutPadding", "valueBytesBigEndian", "", "errorProperties", "message", "throwable", "", "eventData", "eventName", "properties", "addUniqueId", "getAndResetBuildCount", "", "hashBase64WithoutPadding", "input", "sendEvent", "eventProperties", "sendUniqueId", "sendEventImpl", "shouldSendBuildEvent", "trackError", "trackFatal", "trackNoBuildPropertiesFile", "trackStats", "completed", "daoCompat", "entityCount", "propertyCount", "toOneCount", "toManyCount", "uniqueIdentifier", "version", "comma", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "key", "value", "valueEscaped", "Companion", "objectbox-code-modifier"})
public class BasicBuildTracker {
    private final BuildPropertiesFile buildPropertiesFile;
    private boolean disconnect;
    private final String toolName;
    private static final String PROPERTIES_KEY_UID = "uid";
    private static final String PROPERTIES_KEY_LAST_DAY_BUILD_SENT = "lastBuildEvent";
    private static final String PROPERTIES_KEY_BUILD_COUNT = "buildCount";
    private static final int HOUR_IN_MILLIS = 3600000;
    @NotNull
    public static final String BASE_URL = "https://api.mixpanel.com/track#live-event";
    @NotNull
    public static final String TOKEN = "46d62a7c8def175e66900b3da09d698c";
    public static final int TIMEOUT_READ = 15000;
    public static final int TIMEOUT_CONNECT = 20000;
    @NotNull
    private static final Companion Companion = new Companion(null);

    public final boolean getDisconnect() {
        return this.disconnect;
    }

    public final void setDisconnect(boolean bl) {
        this.disconnect = bl;
    }

    public final boolean shouldSendBuildEvent() {
        boolean bl;
        Long timestamp;
        String timeProperty;
        String string = timeProperty = this.buildPropertiesFile.getProperties().getProperty(PROPERTIES_KEY_LAST_DAY_BUILD_SENT);
        Long l = timestamp = string != null ? StringsKt.toLongOrNull((String)string) : null;
        if (timestamp == null || timestamp < System.currentTimeMillis() - (long)86400000) {
            ((Map)this.buildPropertiesFile.getProperties()).put(PROPERTIES_KEY_LAST_DAY_BUILD_SENT, String.valueOf(System.currentTimeMillis()));
            this.buildPropertiesFile.write();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void countBuild() {
        String countProperty;
        String string = countProperty = this.buildPropertiesFile.getProperties().getProperty(PROPERTIES_KEY_BUILD_COUNT);
        Integer buildCount = string != null ? StringsKt.toIntOrNull((String)string) : null;
        int newBuildCount = buildCount == null || buildCount < 0 ? 1 : buildCount + 1;
        ((Map)this.buildPropertiesFile.getProperties()).put(PROPERTIES_KEY_BUILD_COUNT, String.valueOf(newBuildCount));
        this.buildPropertiesFile.write();
    }

    public final int getAndResetBuildCount() {
        String countProperty = this.buildPropertiesFile.getProperties().getProperty(PROPERTIES_KEY_BUILD_COUNT);
        ((Map)this.buildPropertiesFile.getProperties()).put(PROPERTIES_KEY_BUILD_COUNT, "0");
        this.buildPropertiesFile.write();
        Object object = countProperty;
        return object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 1;
    }

    public final void trackError(@Nullable String message, @Nullable Throwable throwable) {
        BasicBuildTracker.sendEvent$default(this, "Error", this.errorProperties(message, throwable), false, 4, null);
    }

    public static /* synthetic */ void trackError$default(BasicBuildTracker basicBuildTracker, String string, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: trackError");
        }
        if ((n & 2) != 0) {
            throwable = null;
        }
        basicBuildTracker.trackError(string, throwable);
    }

    public final void trackFatal(@Nullable String message, @Nullable Throwable throwable) {
        BasicBuildTracker.sendEvent$default(this, "Fatal", this.errorProperties(message, throwable), false, 4, null);
    }

    public static /* synthetic */ void trackFatal$default(BasicBuildTracker basicBuildTracker, String string, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: trackFatal");
        }
        if ((n & 2) != 0) {
            throwable = null;
        }
        basicBuildTracker.trackFatal(string, throwable);
    }

    public final void trackNoBuildPropertiesFile(@Nullable String message, @Nullable Throwable throwable) {
        this.sendEvent("NoBuildProperties", this.errorProperties(message, throwable), false);
    }

    public static /* synthetic */ void trackNoBuildPropertiesFile$default(BasicBuildTracker basicBuildTracker, String string, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: trackNoBuildPropertiesFile");
        }
        if ((n & 2) != 0) {
            throwable = null;
        }
        basicBuildTracker.trackNoBuildPropertiesFile(string, throwable);
    }

    public final void trackStats(boolean completed, boolean daoCompat, int entityCount, int propertyCount, int toOneCount, int toManyCount) {
        StringBuilder event = new StringBuilder();
        this.comma(this.value(this.key(event, "DC"), String.valueOf(daoCompat)));
        this.comma(this.value(this.key(event, "EC"), String.valueOf(entityCount)));
        this.comma(this.value(this.key(event, "PC"), String.valueOf(propertyCount)));
        this.comma(this.value(this.key(event, "T1C"), String.valueOf(toOneCount)));
        this.comma(this.value(this.key(event, "TMC"), String.valueOf(toManyCount)));
        this.value(this.key(event, "OK"), String.valueOf(completed));
        String string = event.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.toString()");
        BasicBuildTracker.sendEvent$default(this, "Stats", string, false, 4, null);
    }

    public final void sendEvent(@NotNull String eventName, @NotNull String eventProperties, boolean sendUniqueId) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Intrinsics.checkNotNullParameter((Object)eventProperties, (String)"eventProperties");
        if (sendUniqueId && this.buildPropertiesFile.getHasNoFile()) {
            return;
        }
        this.sendEventImpl(eventName, eventProperties, sendUniqueId);
    }

    public static /* synthetic */ void sendEvent$default(BasicBuildTracker basicBuildTracker, String string, String string2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendEvent");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        basicBuildTracker.sendEvent(string, string2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String sendEventImpl(@NotNull String eventName, @NotNull String eventProperties, boolean sendUniqueId) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Intrinsics.checkNotNullParameter((Object)eventProperties, (String)"eventProperties");
        String event = this.eventData(eventName, eventProperties, sendUniqueId);
        try {
            URL url = new URL(BASE_URL);
            URLConnection uRLConnection = url.openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            HttpURLConnection con = (HttpURLConnection)uRLConnection;
            con.setConnectTimeout(20000);
            con.setReadTimeout(15000);
            con.setRequestProperty("Accept", "text/plain");
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setDoOutput(true);
            OutputStream outputStream = con.getOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"con.outputStream");
            Closeable closeable = outputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable2 = closeable;
            int n = 0;
            closeable2 = new OutputStreamWriter((OutputStream)closeable2, charset);
            n = 8192;
            int n2 = 0;
            closeable = closeable2 instanceof BufferedWriter ? (BufferedWriter)closeable2 : new BufferedWriter((Writer)closeable2, n);
            boolean bl2 = false;
            bl = false;
            Object object = null;
            try {
                BufferedWriter it = (BufferedWriter)closeable;
                boolean bl3 = false;
                it.write("data=" + event);
                closeable2 = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            InputStream inputStream = con.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"con.inputStream");
            InputStream inputStream2 = inputStream;
            object = Charsets.UTF_8;
            boolean bl4 = false;
            Closeable closeable3 = inputStream2;
            n2 = 0;
            closeable3 = new InputStreamReader((InputStream)closeable3, (Charset)object);
            n2 = 8192;
            boolean bl5 = false;
            String response = (closeable3 instanceof BufferedReader ? (BufferedReader)closeable3 : new BufferedReader((Reader)closeable3, n2)).readLine();
            if (this.disconnect) {
                con.disconnect();
            }
            return response;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @NotNull
    public final String eventData(@NotNull String eventName, @NotNull String properties, boolean addUniqueId) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        StringBuilder event = new StringBuilder();
        event.append("{");
        this.comma(this.value(this.key(event, "event"), eventName));
        this.key(event, "properties").append("{");
        this.comma(this.value(this.key(event, "token"), TOKEN));
        if (addUniqueId) {
            this.comma(this.value(this.key(event, "distinct_id"), this.uniqueIdentifier()));
        }
        this.comma(this.value(this.key(event, "Tool"), this.toolName));
        try {
            Locale locale;
            Locale locale2 = locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"locale");
            String language = locale2.getISO3Language();
            String country = locale.getISO3Country();
            StringBuilder stringBuilder = this.key(event, "lang").append('\"' + language + '\"');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"event.key(\"lang\").append(\"\\\"$language\\\"\")");
            this.comma(stringBuilder);
            StringBuilder stringBuilder2 = this.key(event, "c").append('\"' + country + '\"');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"event.key(\"c\").append(\"\\\"$country\\\"\")");
            this.comma(stringBuilder2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        event.append(properties);
        event.append("}").append("}");
        String string = event.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.toString()");
        return string;
    }

    @Nullable
    protected String version() {
        return "3.2.0";
    }

    @NotNull
    public final String errorProperties(@Nullable String message, @Nullable Throwable throwable) {
        String version;
        StringBuilder event = new StringBuilder();
        if (message != null) {
            this.comma(this.valueEscaped(this.key(event, "Message"), message));
        }
        if ((version = this.version()) != null) {
            this.valueEscaped(this.key(event, "Version"), version);
        }
        if (throwable != null) {
            this.comma(event);
            int n = 1;
            Throwable ex = throwable;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            ex.printStackTrace(printWriter);
            StringBuilder stringBuilder = this.key(event, "ExStack");
            String string = stringWriter.getBuffer().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringWriter.buffer.toString()");
            this.valueEscaped(stringBuilder, string);
            while (ex != null) {
                this.comma(event);
                StringBuilder stringBuilder2 = this.key(event, "ExMessage" + n);
                String string2 = ex.getMessage();
                if (string2 == null) {
                    string2 = "na";
                }
                this.comma(this.valueEscaped(stringBuilder2, string2));
                StringBuilder stringBuilder3 = this.key(event, "ExClass" + n);
                String string3 = ex.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ex.javaClass.name");
                this.value(stringBuilder3, string3);
                if (Intrinsics.areEqual((Object)ex.getCause(), (Object)ex) ^ true) {
                    ex = ex.getCause();
                }
                ++n;
            }
        }
        String string = event.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.toString()");
        return string;
    }

    @NotNull
    protected final StringBuilder key(@NotNull StringBuilder $this$key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$key, (String)"$this$key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $this$key.append('\"' + value + "\": ");
        return $this$key;
    }

    @NotNull
    protected final StringBuilder value(@NotNull StringBuilder $this$value, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$value, (String)"$this$value");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $this$value.append('\"' + value + '\"');
        return $this$value;
    }

    @NotNull
    protected final StringBuilder valueEscaped(@NotNull StringBuilder $this$valueEscaped, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$valueEscaped, (String)"$this$valueEscaped");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Buffer buffer = new Buffer();
        JsonWriter.of((BufferedSink)((BufferedSink)buffer)).value(value);
        $this$valueEscaped.append(buffer.readUtf8());
        return $this$valueEscaped;
    }

    @NotNull
    protected final StringBuilder comma(@NotNull StringBuilder $this$comma) {
        Intrinsics.checkNotNullParameter((Object)$this$comma, (String)"$this$comma");
        $this$comma.append(',');
        return $this$comma;
    }

    @NotNull
    public final String hashBase64WithoutPadding(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Murmur3F murmurHash = new Murmur3F();
        String string = input;
        Object object = Charsets.UTF_8;
        int n = 0;
        byte[] byArray = string.getBytes((Charset)object);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        murmurHash.update(byArray);
        byte[] byArray2 = murmurHash.getValueBytesBigEndian();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"murmurHash.valueBytesBigEndian");
        object = byArray2;
        n = 8;
        boolean bl = false;
        byte[] byArray3 = Arrays.copyOf((byte[])object, n);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"java.util.Arrays.copyOf(this, newSize)");
        byte[] bytes = byArray3;
        return this.encodeBase64WithoutPadding(bytes);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String uniqueIdentifier() {
        String string;
        String uid = this.buildPropertiesFile.getProperties().getProperty(PROPERTIES_KEY_UID);
        CharSequence charSequence = uid;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            void var3_4;
            byte[] bytes = new byte[8];
            new SecureRandom().nextBytes(bytes);
            String newUid = this.encodeBase64WithoutPadding(bytes);
            ((Map)this.buildPropertiesFile.getProperties()).put(PROPERTIES_KEY_UID, newUid);
            this.buildPropertiesFile.write();
            string = var3_4;
        } else {
            string = uid;
        }
        return string;
    }

    private final String encodeBase64WithoutPadding(byte[] valueBytesBigEndian) {
        String string = Base64.getEncoder().encodeToString(valueBytesBigEndian);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Base64.getEncoder().enco\u2026ring(valueBytesBigEndian)");
        return StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)string, (CharSequence)"="), (CharSequence)"=");
    }

    public BasicBuildTracker(@NotNull String toolName) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        this.toolName = toolName;
        this.buildPropertiesFile = new BuildPropertiesFile(new BuildPropertiesFile.FileCreateListener(this){
            final /* synthetic */ BasicBuildTracker this$0;

            public void onFailedToCreateFile(@NotNull String message, @NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.trackNoBuildPropertiesFile(message, e);
            }
            {
                this.this$0 = this$0;
            }
        });
        this.disconnect = true;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/objectbox/reporting/BasicBuildTracker$Companion;", "", "()V", "BASE_URL", "", "HOUR_IN_MILLIS", "", "PROPERTIES_KEY_BUILD_COUNT", "PROPERTIES_KEY_LAST_DAY_BUILD_SENT", "PROPERTIES_KEY_UID", "TIMEOUT_CONNECT", "TIMEOUT_READ", "TOKEN", "objectbox-code-modifier"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

