/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.generator.idsync;

import io.objectbox.generator.idsync.IdSyncException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.greenrobot.essentials.hash.Murmur3F;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u0014\u0010\u000f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011J\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lio/objectbox/generator/idsync/UidHelper;", "", "existingUids", "", "", "(Ljava/util/Set;)V", "getExistingUids", "()Ljava/util/Set;", "random", "Ljava/security/SecureRandom;", "getRandom", "()Ljava/security/SecureRandom;", "addExistingId", "", "id", "addExistingIds", "ids", "", "create", "verify", "value", "objectbox-code-modifier"})
public final class UidHelper {
    @NotNull
    private final SecureRandom random;
    @NotNull
    private final Set<Long> existingUids;

    @NotNull
    public final SecureRandom getRandom() {
        return this.random;
    }

    public final void addExistingId(long id) {
        this.verify(id);
        if (!this.existingUids.add(id)) {
            throw (Throwable)new IdSyncException("Duplicate UID " + id, null, 2, null);
        }
    }

    public final void addExistingIds(@NotNull Collection<Long> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            this.addExistingId(it);
        }
    }

    public final long create() {
        Murmur3F murmur;
        long randomPart;
        long newId = 0L;
        do {
            randomPart = 1L + this.random.nextLong() & 0x7FFFFFFFFFFFFF00L;
            murmur = new Murmur3F();
            murmur.updateLongLE(randomPart);
        } while (!this.existingUids.add(newId = randomPart | murmur.getValue() & 0xFFL));
        return newId;
    }

    public final void verify(long value) {
        if (value < 0L) {
            throw (Throwable)new IdSyncException("Illegal UID: " + value, null, 2, null);
        }
        long randomPart = value & 0x7FFFFFFFFFFFFF00L;
        if (randomPart == 0L) {
            throw (Throwable)new IdSyncException("Illegal UID: " + value, null, 2, null);
        }
        Murmur3F murmur = new Murmur3F();
        murmur.updateLongLE(randomPart);
        if (value < 0L || (value & 0xFFL) != (murmur.getValue() & 0xFFL)) {
            throw (Throwable)new IdSyncException("Illegal UID: " + value, null, 2, null);
        }
    }

    @NotNull
    public final Set<Long> getExistingUids() {
        return this.existingUids;
    }

    public UidHelper(@NotNull Set<Long> existingUids) {
        Intrinsics.checkNotNullParameter(existingUids, (String)"existingUids");
        this.existingUids = existingUids;
        this.random = new SecureRandom();
        Iterable $this$forEach$iv = this.existingUids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            this.verify(it);
        }
    }

    public /* synthetic */ UidHelper(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = new HashSet();
        }
        this(set);
    }

    public UidHelper() {
        this(null, 1, null);
    }
}

