/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.unix.tests;

import io.netty5.buffer.ByteBuf;
import io.netty5.buffer.ByteBufAllocator;
import io.netty5.buffer.Unpooled;
import io.netty5.buffer.UnpooledByteBufAllocator;
import io.netty5.buffer.UnpooledDirectByteBuf;
import io.netty5.channel.unix.IovArray;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class IovArrayTest {
    @Test
    public void testNotFailsWihtoutMemoryAddress() {
        NoMemoryAddressByteBuf buffer = new NoMemoryAddressByteBuf(128);
        IovArray array = new IovArray((ByteBuf)buffer);
        ByteBuf buf = Unpooled.directBuffer().writeZero(8);
        ByteBuf buf2 = new NoMemoryAddressByteBuf(8).writeZero(8);
        Assertions.assertTrue((boolean)array.add(buf, 0, buf.readableBytes()));
        Assertions.assertTrue((boolean)array.add(buf, 0, buf2.readableBytes()));
        Assertions.assertEquals((int)2, (int)array.count());
        Assertions.assertEquals((long)16L, (long)array.size());
        Assertions.assertTrue((boolean)buf.release());
        Assertions.assertTrue((boolean)buf2.release());
        Assertions.assertNotEquals((long)-1L, (long)array.memoryAddress(0));
        array.release();
        Assertions.assertEquals((int)0, (int)buffer.refCnt());
    }

    private static final class NoMemoryAddressByteBuf
    extends UnpooledDirectByteBuf {
        NoMemoryAddressByteBuf(int capacity) {
            super((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, capacity, Integer.MAX_VALUE);
        }

        public boolean hasMemoryAddress() {
            return false;
        }

        public long memoryAddress() {
            throw new UnsupportedOperationException();
        }
    }
}

