/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver.dns;

import io.netty5.resolver.NameResolver;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.StringUtil;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;

final class InflightNameResolver<T>
implements NameResolver<T> {
    private final EventExecutor executor;
    private final NameResolver<T> delegate;
    private final ConcurrentMap<String, Promise<T>> resolvesInProgress;
    private final ConcurrentMap<String, Promise<List<T>>> resolveAllsInProgress;

    InflightNameResolver(EventExecutor executor, NameResolver<T> delegate, ConcurrentMap<String, Promise<T>> resolvesInProgress, ConcurrentMap<String, Promise<List<T>>> resolveAllsInProgress) {
        this.executor = Objects.requireNonNull(executor, "executor");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.resolvesInProgress = Objects.requireNonNull(resolvesInProgress, "resolvesInProgress");
        this.resolveAllsInProgress = Objects.requireNonNull(resolveAllsInProgress, "resolveAllsInProgress");
    }

    public Future<T> resolve(String inetHost) {
        return this.resolve(inetHost, this.executor.newPromise());
    }

    public Future<List<T>> resolveAll(String inetHost) {
        return this.resolveAll(inetHost, this.executor.newPromise());
    }

    public void close() {
        this.delegate.close();
    }

    public Future<T> resolve(String inetHost, Promise<T> promise) {
        return this.resolve(this.resolvesInProgress, inetHost, promise, false);
    }

    public Future<List<T>> resolveAll(String inetHost, Promise<List<T>> promise) {
        return this.resolve(this.resolveAllsInProgress, inetHost, promise, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <U> Future<U> resolve(ConcurrentMap<String, Promise<U>> resolveMap, String inetHost, Promise<U> promise, boolean resolveAll) {
        Promise<U> earlyPromise = resolveMap.putIfAbsent(inetHost, promise);
        if (earlyPromise != null) {
            Future earlyFuture = promise.asFuture();
            if (earlyFuture.isDone()) {
                InflightNameResolver.transferResult(earlyFuture, promise);
            } else {
                earlyFuture.addListener(f -> InflightNameResolver.transferResult(f, promise));
            }
        } else {
            try {
                if (resolveAll) {
                    Promise castPromise = promise;
                    this.delegate.resolveAll(inetHost, castPromise);
                } else {
                    Promise castPromise = promise;
                    this.delegate.resolve(inetHost, castPromise);
                }
            }
            finally {
                if (promise.isDone()) {
                    resolveMap.remove(inetHost);
                } else {
                    promise.asFuture().addListener(f -> resolveMap.remove(inetHost));
                }
            }
        }
        return promise.asFuture();
    }

    private static <T> void transferResult(Future<? extends T> src, Promise<T> dst) {
        if (src.isSuccess()) {
            dst.trySuccess(src.getNow());
        } else {
            dst.tryFailure(src.cause());
        }
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this) + "(" + this.delegate + ")";
    }
}

