/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver.dns;

import io.netty5.resolver.dns.DefaultDnsServerAddressStreamProvider;
import io.netty5.resolver.dns.DnsServerAddressStream;
import io.netty5.resolver.dns.DnsServerAddressStreamProvider;
import io.netty5.resolver.dns.UnixResolverDnsServerAddressStreamProvider;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class DnsServerAddressStreamProviders {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(DnsServerAddressStreamProviders.class);
    private static final MethodHandle STREAM_PROVIDER_CONSTRUCTOR_HANDLE;
    private static final String MACOS_PROVIDER_CLASS_NAME = "io.netty5.resolver.dns.macos.MacOSDnsServerAddressStreamProvider";

    private DnsServerAddressStreamProviders() {
    }

    public static DnsServerAddressStreamProvider platformDefault() {
        if (STREAM_PROVIDER_CONSTRUCTOR_HANDLE != null) {
            try {
                return STREAM_PROVIDER_CONSTRUCTOR_HANDLE.invoke();
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            }
            catch (Throwable cause) {
                PlatformDependent.throwException((Throwable)cause);
            }
        }
        return DnsServerAddressStreamProviders.unixDefault();
    }

    public static DnsServerAddressStreamProvider unixDefault() {
        return DefaultProviderHolder.DEFAULT_DNS_SERVER_ADDRESS_STREAM_PROVIDER;
    }

    static {
        MethodHandle constructorHandle = null;
        if (PlatformDependent.isOsx()) {
            try {
                Object maybeProvider = AccessController.doPrivileged(() -> {
                    try {
                        return Class.forName(MACOS_PROVIDER_CLASS_NAME, true, DnsServerAddressStreamProviders.class.getClassLoader());
                    }
                    catch (Throwable cause) {
                        return cause;
                    }
                });
                if (!(maybeProvider instanceof Class)) {
                    throw (Throwable)maybeProvider;
                }
                Class providerClass = (Class)maybeProvider;
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                constructorHandle = lookup.findConstructor(providerClass, MethodType.methodType(Void.TYPE));
                constructorHandle.invoke();
                LOGGER.debug("{}: available", (Object)MACOS_PROVIDER_CLASS_NAME);
            }
            catch (ClassNotFoundException cause) {
                LOGGER.warn("Can not find {} in the classpath, fallback to system defaults. This may result in incorrect DNS resolutions on MacOS.", (Object)MACOS_PROVIDER_CLASS_NAME);
            }
            catch (Throwable cause) {
                LOGGER.error("Unable to load {}, fallback to system defaults. This may result in incorrect DNS resolutions on MacOS.", (Object)MACOS_PROVIDER_CLASS_NAME, (Object)cause);
                constructorHandle = null;
            }
        }
        STREAM_PROVIDER_CONSTRUCTOR_HANDLE = constructorHandle;
    }

    private static final class DefaultProviderHolder {
        private static final long REFRESH_INTERVAL = TimeUnit.MINUTES.toNanos(5L);
        static final DnsServerAddressStreamProvider DEFAULT_DNS_SERVER_ADDRESS_STREAM_PROVIDER = new DnsServerAddressStreamProvider(){
            private volatile DnsServerAddressStreamProvider currentProvider = this.provider();
            private final AtomicLong lastRefresh = new AtomicLong(System.nanoTime());

            @Override
            public DnsServerAddressStream nameServerAddressStream(String hostname) {
                long last = this.lastRefresh.get();
                DnsServerAddressStreamProvider current = this.currentProvider;
                if (System.nanoTime() - last > REFRESH_INTERVAL && this.lastRefresh.compareAndSet(last, System.nanoTime())) {
                    current = this.currentProvider = this.provider();
                }
                return current.nameServerAddressStream(hostname);
            }

            private DnsServerAddressStreamProvider provider() {
                return PlatformDependent.isWindows() ? DefaultDnsServerAddressStreamProvider.INSTANCE : UnixResolverDnsServerAddressStreamProvider.parseSilently();
            }
        };

        private DefaultProviderHolder() {
        }
    }
}

