/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver.dns;

import io.netty5.channel.AddressedEnvelope;
import io.netty5.channel.Channel;
import io.netty5.handler.codec.dns.AbstractDnsOptPseudoRrRecord;
import io.netty5.handler.codec.dns.DnsQuery;
import io.netty5.handler.codec.dns.DnsQuestion;
import io.netty5.handler.codec.dns.DnsRecord;
import io.netty5.handler.codec.dns.DnsRecordType;
import io.netty5.handler.codec.dns.DnsResponse;
import io.netty5.handler.codec.dns.DnsSection;
import io.netty5.resolver.dns.DnsNameResolver;
import io.netty5.resolver.dns.DnsNameResolverException;
import io.netty5.resolver.dns.DnsNameResolverTimeoutException;
import io.netty5.util.ReferenceCountUtil;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureListener;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

abstract class DnsQueryContext
implements FutureListener<AddressedEnvelope<DnsResponse, InetSocketAddress>> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DnsQueryContext.class);
    private final DnsNameResolver parent;
    private final Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise;
    private final int id;
    private final DnsQuestion question;
    private final DnsRecord[] additionals;
    private final DnsRecord optResource;
    private final InetSocketAddress nameServerAddr;
    private final boolean recursionDesired;
    private volatile Future<?> timeoutFuture;

    DnsQueryContext(DnsNameResolver parent, InetSocketAddress nameServerAddr, DnsQuestion question, DnsRecord[] additionals, Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise) {
        this.parent = Objects.requireNonNull(parent, "parent");
        this.nameServerAddr = Objects.requireNonNull(nameServerAddr, "nameServerAddr");
        this.question = Objects.requireNonNull(question, "question");
        this.additionals = Objects.requireNonNull(additionals, "additionals");
        this.promise = Objects.requireNonNull(promise, "promise");
        this.recursionDesired = parent.isRecursionDesired();
        this.id = parent.queryContextManager.add(this);
        promise.asFuture().addListener((FutureListener)this);
        this.optResource = parent.isOptResourceEnabled() && !DnsQueryContext.hasOptRecord(additionals) ? new AbstractDnsOptPseudoRrRecord(parent.maxPayloadSize(), 0, 0){} : null;
    }

    private static boolean hasOptRecord(DnsRecord[] additionals) {
        if (additionals != null && additionals.length > 0) {
            for (DnsRecord additional : additionals) {
                if (additional.type() != DnsRecordType.OPT) continue;
                return true;
            }
        }
        return false;
    }

    InetSocketAddress nameServerAddr() {
        return this.nameServerAddr;
    }

    DnsQuestion question() {
        return this.question;
    }

    DnsNameResolver parent() {
        return this.parent;
    }

    protected abstract DnsQuery newQuery(int var1);

    protected abstract Channel channel();

    protected abstract String protocol();

    void query(boolean flush, Promise<Void> writePromise) {
        DnsQuestion question = this.question();
        InetSocketAddress nameServerAddr = this.nameServerAddr();
        DnsQuery query = this.newQuery(this.id);
        query.setRecursionDesired(this.recursionDesired);
        query.addRecord(DnsSection.QUESTION, (DnsRecord)question);
        for (DnsRecord record : this.additionals) {
            query.addRecord(DnsSection.ADDITIONAL, record);
        }
        if (this.optResource != null) {
            query.addRecord(DnsSection.ADDITIONAL, this.optResource);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} WRITE: {}, [{}: {}], {}", new Object[]{this.channel(), this.protocol(), this.id, nameServerAddr, question});
        }
        this.sendQuery(query, flush, writePromise);
    }

    private void sendQuery(DnsQuery query, boolean flush, Promise<Void> writePromise) {
        if (this.parent.channelReadyPromise.isSuccess()) {
            this.writeQuery(query, flush, writePromise);
        } else if (this.parent.channelReadyPromise.isFailed()) {
            this.failQuery(query, this.parent.channelReadyPromise.cause(), writePromise);
        } else {
            this.parent.channelReadyPromise.asFuture().addListener(future -> {
                if (future.isSuccess()) {
                    this.writeQuery(query, true, writePromise);
                } else {
                    this.failQuery(query, future.cause(), writePromise);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failQuery(DnsQuery query, Throwable cause, Promise<Void> writePromise) {
        try {
            this.promise.tryFailure(cause);
            writePromise.setFailure(cause);
        }
        finally {
            ReferenceCountUtil.release((Object)query);
        }
    }

    private void writeQuery(DnsQuery query, boolean flush, Promise<Void> writePromise) {
        Future writeFuture;
        Future future2 = writeFuture = flush ? this.channel().writeAndFlush((Object)query) : this.channel().write((Object)query);
        if (writeFuture.isDone()) {
            this.onQueryWriteCompletion(writeFuture, writePromise);
        } else {
            writeFuture.addListener(future -> this.onQueryWriteCompletion(future, writePromise));
        }
    }

    private void onQueryWriteCompletion(Future<?> writeFuture, Promise<Void> writePromise) {
        if (writeFuture.isFailed()) {
            writePromise.setFailure(writeFuture.cause());
            this.tryFailure("failed to send a query via " + this.protocol(), writeFuture.cause(), false);
            return;
        }
        writePromise.setSuccess(null);
        long queryTimeoutMillis = this.parent.queryTimeoutMillis();
        if (queryTimeoutMillis > 0L) {
            this.timeoutFuture = this.parent.ch.executor().schedule(() -> {
                if (this.promise.isDone()) {
                    return;
                }
                this.tryFailure("query via " + this.protocol() + " timed out after " + queryTimeoutMillis + " milliseconds", null, true);
            }, queryTimeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    void finish(AddressedEnvelope<? extends DnsResponse, InetSocketAddress> envelope) {
        DnsResponse res = (DnsResponse)envelope.content();
        if (res.count(DnsSection.QUESTION) != 1) {
            logger.warn("Received a DNS response with invalid number of questions: {}", envelope);
        } else if (!this.question().equals(res.recordAt(DnsSection.QUESTION))) {
            logger.warn("Received a mismatching DNS response: {}", envelope);
        } else if (this.trySuccess(envelope)) {
            return;
        }
        ReferenceCountUtil.release(envelope);
    }

    private boolean trySuccess(AddressedEnvelope<? extends DnsResponse, InetSocketAddress> envelope) {
        return this.promise.trySuccess(envelope);
    }

    boolean tryFailure(String message, Throwable cause, boolean timeout) {
        if (this.promise.isDone()) {
            return false;
        }
        InetSocketAddress nameServerAddr = this.nameServerAddr();
        StringBuilder buf = new StringBuilder(message.length() + 64);
        buf.append('[').append(nameServerAddr).append("] ").append(message).append(" (no stack trace available)");
        DnsNameResolverException e = timeout ? new DnsNameResolverTimeoutException(nameServerAddr, this.question(), buf.toString()) : new DnsNameResolverException(nameServerAddr, this.question(), buf.toString(), cause);
        return this.promise.tryFailure((Throwable)e);
    }

    public void operationComplete(Future<? extends AddressedEnvelope<DnsResponse, InetSocketAddress>> future) {
        Future<?> timeoutFuture = this.timeoutFuture;
        if (timeoutFuture != null) {
            this.timeoutFuture = null;
            timeoutFuture.cancel();
        }
        this.parent.queryContextManager.remove(this.nameServerAddr, this.id);
    }
}

