/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver.dns;

import io.netty5.channel.EventLoop;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureCompletionStage;
import io.netty5.util.concurrent.FutureContextListener;
import io.netty5.util.concurrent.FutureListener;
import io.netty5.util.concurrent.Promise;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;

abstract class Cache<E> {
    private static final AtomicReferenceFieldUpdater<Entries, FutureAndDelay> FUTURE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Entries.class, FutureAndDelay.class, "expirationFuture");
    private static final Future<?> CANCELLED_FUTURE = new Future<Object>(){

        public boolean cancel() {
            return false;
        }

        public boolean isSuccess() {
            return false;
        }

        public boolean isFailed() {
            return true;
        }

        public boolean isCancellable() {
            return false;
        }

        public Throwable cause() {
            return new CancellationException();
        }

        public Future<Object> addListener(FutureListener<? super Object> listener) {
            throw new UnsupportedOperationException();
        }

        public <C> Future<Object> addListener(C context, FutureContextListener<? super C, ? super Object> listener) {
            throw new UnsupportedOperationException();
        }

        public Future<Object> sync() throws InterruptedException {
            return this;
        }

        public Future<Object> syncUninterruptibly() {
            return this;
        }

        public Future<Object> await() throws InterruptedException {
            return this;
        }

        public Future<Object> awaitUninterruptibly() {
            return this;
        }

        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            return true;
        }

        public boolean await(long timeoutMillis) throws InterruptedException {
            return true;
        }

        public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
            return true;
        }

        public boolean awaitUninterruptibly(long timeoutMillis) {
            return true;
        }

        public Object getNow() {
            return null;
        }

        public EventExecutor executor() {
            throw new UnsupportedOperationException();
        }

        public boolean isCancelled() {
            return true;
        }

        public boolean isDone() {
            return true;
        }

        public Object get() {
            throw new UnsupportedOperationException();
        }

        public Object get(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public FutureCompletionStage<Object> asStage() {
            throw new UnsupportedOperationException();
        }

        public <R> Future<R> map(Function<Object, R> mapper) {
            throw new UnsupportedOperationException();
        }

        public <R> Future<R> flatMap(Function<Object, Future<R>> mapper) {
            throw new UnsupportedOperationException();
        }

        public Future<Object> cascadeTo(Promise<? super Object> promise) {
            throw new UnsupportedOperationException();
        }
    };
    private static final FutureAndDelay CANCELLED = new FutureAndDelay(CANCELLED_FUTURE, Integer.MIN_VALUE);
    static final int MAX_SUPPORTED_TTL_SECS = (int)TimeUnit.DAYS.toSeconds(730L);
    private final ConcurrentMap<String, Entries> resolveCache = new ConcurrentHashMap<String, Entries>();

    Cache() {
    }

    final void clear() {
        while (!this.resolveCache.isEmpty()) {
            Iterator i = this.resolveCache.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                i.remove();
                ((Entries)e.getValue()).clearAndCancel();
            }
        }
    }

    final boolean clear(String hostname) {
        Entries entries = (Entries)this.resolveCache.remove(hostname);
        return entries != null && entries.clearAndCancel();
    }

    final List<? extends E> get(String hostname) {
        Entries entries = (Entries)this.resolveCache.get(hostname);
        return entries == null ? null : (List)entries.get();
    }

    final void cache(String hostname, E value, int ttl, EventLoop loop) {
        Entries oldEntries;
        Entries entries = (Entries)this.resolveCache.get(hostname);
        if (entries == null && (oldEntries = this.resolveCache.putIfAbsent(hostname, entries = new Entries(hostname))) != null) {
            entries = oldEntries;
        }
        entries.add(value, ttl, loop);
    }

    final int size() {
        return this.resolveCache.size();
    }

    protected abstract boolean shouldReplaceAll(E var1);

    protected void sortEntries(String hostname, List<E> entries) {
    }

    protected abstract boolean equals(E var1, E var2);

    private static final class FutureAndDelay
    implements Delayed {
        final Future<?> future;
        final long deadlineNanos;

        private FutureAndDelay(Future<?> future, int ttl) {
            this.future = Objects.requireNonNull(future, "future");
            this.deadlineNanos = System.nanoTime() + TimeUnit.SECONDS.toNanos(ttl);
        }

        void cancel() {
            this.future.cancel();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.deadlineNanos - System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            return Long.compare(this.deadlineNanos, other.getDelay(TimeUnit.NANOSECONDS));
        }

        public boolean equals(Object o) {
            return o instanceof FutureAndDelay && this.compareTo((FutureAndDelay)o) == 0;
        }

        public int hashCode() {
            int result = this.future.hashCode();
            result = 31 * result + (int)(this.deadlineNanos ^ this.deadlineNanos >>> 32);
            return result;
        }
    }

    private final class Entries
    extends AtomicReference<List<E>>
    implements Runnable {
        private final String hostname;
        volatile FutureAndDelay expirationFuture;

        Entries(String hostname) {
            super(Collections.emptyList());
            this.hostname = hostname;
        }

        void add(E e, int ttl, EventLoop loop) {
            if (!Cache.this.shouldReplaceAll(e)) {
                while (true) {
                    List entries;
                    if (!(entries = (List)this.get()).isEmpty()) {
                        Object firstEntry = entries.get(0);
                        if (Cache.this.shouldReplaceAll(firstEntry)) {
                            assert (entries.size() == 1);
                            if (!this.compareAndSet(entries, Collections.singletonList(e))) continue;
                            this.scheduleCacheExpirationIfNeeded(ttl, loop);
                            return;
                        }
                        ArrayList newEntries = new ArrayList(entries.size() + 1);
                        int i = 0;
                        Object replacedEntry = null;
                        do {
                            Object entry;
                            if (!Cache.this.equals(e, entry = entries.get(i))) {
                                newEntries.add(entry);
                                continue;
                            }
                            replacedEntry = entry;
                            newEntries.add(e);
                            ++i;
                            while (i < entries.size()) {
                                newEntries.add(entries.get(i));
                                ++i;
                            }
                            break;
                        } while (++i < entries.size());
                        if (replacedEntry == null) {
                            newEntries.add(e);
                        }
                        Cache.this.sortEntries(this.hostname, newEntries);
                        if (!this.compareAndSet(entries, Collections.unmodifiableList(newEntries))) continue;
                        this.scheduleCacheExpirationIfNeeded(ttl, loop);
                        return;
                    }
                    if (this.compareAndSet(entries, Collections.singletonList(e))) break;
                }
                this.scheduleCacheExpirationIfNeeded(ttl, loop);
                return;
            }
            this.set(Collections.singletonList(e));
            this.scheduleCacheExpirationIfNeeded(ttl, loop);
        }

        private void scheduleCacheExpirationIfNeeded(int ttl, EventLoop loop) {
            FutureAndDelay oldFuture;
            while ((oldFuture = FUTURE_UPDATER.get(this)) == null || oldFuture.getDelay(TimeUnit.SECONDS) > (long)ttl) {
                Future newFuture = loop.schedule((Runnable)this, (long)ttl, TimeUnit.SECONDS);
                if (FUTURE_UPDATER.compareAndSet(this, oldFuture, new FutureAndDelay(newFuture, ttl))) {
                    if (oldFuture == null) break;
                    oldFuture.cancel();
                    break;
                }
                newFuture.cancel();
            }
        }

        boolean clearAndCancel() {
            List entries = this.getAndSet(Collections.emptyList());
            if (entries.isEmpty()) {
                return false;
            }
            FutureAndDelay expirationFuture = FUTURE_UPDATER.getAndSet(this, CANCELLED);
            if (expirationFuture != null) {
                expirationFuture.cancel();
            }
            return true;
        }

        @Override
        public void run() {
            Cache.this.resolveCache.remove(this.hostname, this);
            this.clearAndCancel();
        }
    }
}

