/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver.dns;

import io.netty5.resolver.dns.DefaultDnsServerAddressStreamProvider;
import io.netty5.resolver.dns.DnsServerAddressStream;
import io.netty5.resolver.dns.DnsServerAddresses;
import io.netty5.util.NetUtil;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class DnsServerAddressesTest {
    private static final InetSocketAddress ADDR1 = new InetSocketAddress(NetUtil.LOCALHOST, 1);
    private static final InetSocketAddress ADDR2 = new InetSocketAddress(NetUtil.LOCALHOST, 2);
    private static final InetSocketAddress ADDR3 = new InetSocketAddress(NetUtil.LOCALHOST, 3);

    @Test
    public void testDefaultAddresses() {
        MatcherAssert.assertThat((Object)DefaultDnsServerAddressStreamProvider.defaultAddressList().size(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void testSequential() {
        DnsServerAddresses seq = DnsServerAddresses.sequential((InetSocketAddress[])new InetSocketAddress[]{ADDR1, ADDR2, ADDR3});
        MatcherAssert.assertThat((Object)seq.stream(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)seq.stream()))));
        for (int j = 0; j < 2; ++j) {
            DnsServerAddressStream i = seq.stream();
            DnsServerAddressesTest.assertNext(i, ADDR1);
            DnsServerAddressesTest.assertNext(i, ADDR2);
            DnsServerAddressesTest.assertNext(i, ADDR3);
            DnsServerAddressesTest.assertNext(i, ADDR1);
            DnsServerAddressesTest.assertNext(i, ADDR2);
            DnsServerAddressesTest.assertNext(i, ADDR3);
        }
    }

    @Test
    public void testRotational() {
        DnsServerAddresses seq = DnsServerAddresses.rotational((InetSocketAddress[])new InetSocketAddress[]{ADDR1, ADDR2, ADDR3});
        DnsServerAddressStream i = seq.stream();
        DnsServerAddressesTest.assertNext(i, ADDR1);
        DnsServerAddressesTest.assertNext(i, ADDR2);
        DnsServerAddressesTest.assertNext(i, ADDR3);
        DnsServerAddressesTest.assertNext(i, ADDR1);
        DnsServerAddressesTest.assertNext(i, ADDR2);
        DnsServerAddressesTest.assertNext(i, ADDR3);
        i = seq.stream();
        DnsServerAddressesTest.assertNext(i, ADDR2);
        DnsServerAddressesTest.assertNext(i, ADDR3);
        DnsServerAddressesTest.assertNext(i, ADDR1);
        DnsServerAddressesTest.assertNext(i, ADDR2);
        DnsServerAddressesTest.assertNext(i, ADDR3);
        DnsServerAddressesTest.assertNext(i, ADDR1);
        i = seq.stream();
        DnsServerAddressesTest.assertNext(i, ADDR3);
        DnsServerAddressesTest.assertNext(i, ADDR1);
        DnsServerAddressesTest.assertNext(i, ADDR2);
        DnsServerAddressesTest.assertNext(i, ADDR3);
        DnsServerAddressesTest.assertNext(i, ADDR1);
        DnsServerAddressesTest.assertNext(i, ADDR2);
        i = seq.stream();
        DnsServerAddressesTest.assertNext(i, ADDR1);
        DnsServerAddressesTest.assertNext(i, ADDR2);
        DnsServerAddressesTest.assertNext(i, ADDR3);
        DnsServerAddressesTest.assertNext(i, ADDR1);
        DnsServerAddressesTest.assertNext(i, ADDR2);
        DnsServerAddressesTest.assertNext(i, ADDR3);
    }

    @Test
    public void testShuffled() {
        DnsServerAddresses seq = DnsServerAddresses.shuffled((InetSocketAddress[])new InetSocketAddress[]{ADDR1, ADDR2, ADDR3});
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        DnsServerAddressStream i = seq.stream();
        for (int j = 0; j < 0x100000; ++j) {
            set.add(i.next());
        }
        MatcherAssert.assertThat((Object)set.size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)seq.stream(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)seq.stream()))));
    }

    @Test
    public void testSingleton() {
        DnsServerAddresses seq = DnsServerAddresses.singleton((InetSocketAddress)ADDR1);
        MatcherAssert.assertThat((Object)seq.stream(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)seq.stream())));
        DnsServerAddressStream i = seq.stream();
        DnsServerAddressesTest.assertNext(i, ADDR1);
        DnsServerAddressesTest.assertNext(i, ADDR1);
        DnsServerAddressesTest.assertNext(i, ADDR1);
    }

    private static void assertNext(DnsServerAddressStream i, InetSocketAddress addr) {
        MatcherAssert.assertThat((Object)i.next(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)addr)));
    }
}

