/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver.dns;

import io.netty5.channel.embedded.EmbeddedChannel;
import io.netty5.resolver.dns.DefaultDnsCnameCache;
import io.netty5.resolver.dns.DnsCnameCache;
import io.netty5.resolver.dns.DnsResolveContext;
import java.net.UnknownHostException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DnsResolveContextTest {
    private static final String HOSTNAME = "netty.io.";

    @Test
    public void testCnameLoop() {
        for (int i = 1; i < 128; ++i) {
            try {
                DnsResolveContext.cnameResolveFromCache((DnsCnameCache)DnsResolveContextTest.buildCache(i), (String)HOSTNAME);
                Assertions.fail();
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    private static DnsCnameCache buildCache(int chainLength) {
        EmbeddedChannel channel = new EmbeddedChannel();
        DefaultDnsCnameCache cache = new DefaultDnsCnameCache();
        if (chainLength == 1) {
            cache.cache(HOSTNAME, HOSTNAME, Long.MAX_VALUE, channel.executor());
        } else {
            Object lastName = HOSTNAME;
            for (int i = 1; i < chainLength; ++i) {
                String nextName = i + "." + (String)lastName;
                cache.cache((String)lastName, nextName, Long.MAX_VALUE, channel.executor());
                lastName = nextName;
            }
            cache.cache((String)lastName, HOSTNAME, Long.MAX_VALUE, channel.executor());
        }
        return cache;
    }
}

