/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver.dns;

import io.netty5.channel.EventLoop;
import io.netty5.channel.MultithreadEventLoopGroup;
import io.netty5.channel.local.LocalHandler;
import io.netty5.channel.nio.NioHandler;
import io.netty5.channel.socket.nio.NioDatagramChannel;
import io.netty5.resolver.AddressResolver;
import io.netty5.resolver.dns.DnsAddressResolverGroup;
import io.netty5.resolver.dns.DnsNameResolverBuilder;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Promise;
import java.net.SocketAddress;
import java.nio.channels.UnsupportedAddressTypeException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DnsAddressResolverGroupTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUseConfiguredEventLoop() throws InterruptedException {
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, NioHandler.newFactory());
        EventLoop loop = group.next();
        MultithreadEventLoopGroup defaultEventLoopGroup = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
        DnsNameResolverBuilder builder = new DnsNameResolverBuilder().eventLoop(loop).channelType(NioDatagramChannel.class);
        DnsAddressResolverGroup resolverGroup = new DnsAddressResolverGroup(builder);
        try {
            Promise promise = loop.newPromise();
            AddressResolver resolver = resolverGroup.getResolver((EventExecutor)defaultEventLoopGroup.next());
            resolver.resolve(new SocketAddress(){
                private static final long serialVersionUID = 3169703458729818468L;
            }).addListener(future -> {
                try {
                    MatcherAssert.assertThat((Object)future.cause(), (Matcher)Matchers.instanceOf(UnsupportedAddressTypeException.class));
                    Assertions.assertTrue((boolean)loop.inEventLoop());
                    promise.setSuccess(null);
                }
                catch (Throwable cause) {
                    promise.setFailure(cause);
                }
            }).await();
            promise.asFuture().sync();
        }
        finally {
            resolverGroup.close();
            group.shutdownGracefully();
            defaultEventLoopGroup.shutdownGracefully();
        }
    }
}

