/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver.dns;

import io.netty5.channel.EventLoop;
import io.netty5.channel.MultithreadEventLoopGroup;
import io.netty5.channel.local.LocalHandler;
import io.netty5.channel.nio.NioHandler;
import io.netty5.resolver.dns.DefaultDnsCnameCache;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultDnsCnameCacheTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpire() throws Throwable {
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
        try {
            EventLoop loop = group.next();
            DefaultDnsCnameCache cache = new DefaultDnsCnameCache();
            cache.cache("netty.io", "mapping.netty.io", 1L, loop);
            Throwable error = (Throwable)loop.schedule(() -> {
                try {
                    Assertions.assertNull((Object)cache.get("netty.io"));
                    return null;
                }
                catch (Throwable cause) {
                    return cause;
                }
            }, 1L, TimeUnit.SECONDS).get();
            if (error != null) {
                throw error;
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testExpireWithDifferentTTLs() {
        DefaultDnsCnameCacheTest.testExpireWithTTL0(1);
        DefaultDnsCnameCacheTest.testExpireWithTTL0(1000);
        DefaultDnsCnameCacheTest.testExpireWithTTL0(1000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testExpireWithTTL0(int days) {
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
        try {
            EventLoop loop = group.next();
            DefaultDnsCnameCache cache = new DefaultDnsCnameCache();
            cache.cache("netty.io", "mapping.netty.io", TimeUnit.DAYS.toSeconds(days), loop);
            Assertions.assertEquals((Object)"mapping.netty.io", (Object)cache.get("netty.io"));
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleCnamesForSameHostname() throws Exception {
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, NioHandler.newFactory());
        try {
            EventLoop loop = group.next();
            DefaultDnsCnameCache cache = new DefaultDnsCnameCache();
            cache.cache("netty.io", "mapping1.netty.io", 10L, loop);
            cache.cache("netty.io", "mapping2.netty.io", 10000L, loop);
            Assertions.assertEquals((Object)"mapping2.netty.io", (Object)cache.get("netty.io"));
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddSameCnameForSameHostname() throws Exception {
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
        try {
            EventLoop loop = group.next();
            DefaultDnsCnameCache cache = new DefaultDnsCnameCache();
            cache.cache("netty.io", "mapping.netty.io", 10L, loop);
            cache.cache("netty.io", "mapping.netty.io", 10000L, loop);
            Assertions.assertEquals((Object)"mapping.netty.io", (Object)cache.get("netty.io"));
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClear() throws Exception {
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
        try {
            EventLoop loop = group.next();
            DefaultDnsCnameCache cache = new DefaultDnsCnameCache();
            cache.cache("x.netty.io", "mapping.netty.io", 100000L, loop);
            cache.cache("y.netty.io", "mapping.netty.io", 100000L, loop);
            Assertions.assertEquals((Object)"mapping.netty.io", (Object)cache.get("x.netty.io"));
            Assertions.assertEquals((Object)"mapping.netty.io", (Object)cache.get("y.netty.io"));
            Assertions.assertTrue((boolean)cache.clear("x.netty.io"));
            Assertions.assertNull((Object)cache.get("x.netty.io"));
            Assertions.assertEquals((Object)"mapping.netty.io", (Object)cache.get("y.netty.io"));
            cache.clear();
            Assertions.assertNull((Object)cache.get("y.netty.io"));
        }
        finally {
            group.shutdownGracefully();
        }
    }
}

