/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.resolver.dns;

import io.netty5.channel.EventLoop;
import io.netty5.channel.MultithreadEventLoopGroup;
import io.netty5.channel.local.LocalHandler;
import io.netty5.channel.nio.NioHandler;
import io.netty5.resolver.dns.DefaultDnsCache;
import io.netty5.resolver.dns.DnsCacheEntry;
import io.netty5.util.NetUtil;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultDnsCacheTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpire() throws Throwable {
        InetAddress addr1 = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress addr2 = InetAddress.getByAddress(new byte[]{10, 0, 0, 2});
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, NioHandler.newFactory());
        try {
            EventLoop loop = group.next();
            DefaultDnsCache cache = new DefaultDnsCache();
            cache.cache("netty.io", null, addr1, 1L, loop);
            cache.cache("netty.io", null, addr2, 10000L, loop);
            Throwable error = (Throwable)loop.schedule(() -> {
                try {
                    Assertions.assertNull((Object)cache.get("netty.io", null));
                    return null;
                }
                catch (Throwable cause) {
                    return cause;
                }
            }, 1L, TimeUnit.SECONDS).get();
            if (error != null) {
                throw error;
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testExpireWithDifferentTTLs() {
        DefaultDnsCacheTest.testExpireWithTTL0(1);
        DefaultDnsCacheTest.testExpireWithTTL0(1000);
        DefaultDnsCacheTest.testExpireWithTTL0(1000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testExpireWithTTL0(int days) {
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, NioHandler.newFactory());
        try {
            EventLoop loop = group.next();
            DefaultDnsCache cache = new DefaultDnsCache();
            Assertions.assertNotNull((Object)cache.cache("netty.io", null, NetUtil.LOCALHOST, (long)days, loop));
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpireWithToBigMinTTL() {
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, NioHandler.newFactory());
        try {
            EventLoop loop = group.next();
            DefaultDnsCache cache = new DefaultDnsCache(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
            Assertions.assertNotNull((Object)cache.cache("netty.io", null, NetUtil.LOCALHOST, 100L, loop));
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddMultipleAddressesForSameHostname() throws Exception {
        InetAddress addr1 = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress addr2 = InetAddress.getByAddress(new byte[]{10, 0, 0, 2});
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
        try {
            EventLoop loop = group.next();
            DefaultDnsCache cache = new DefaultDnsCache();
            cache.cache("netty.io", null, addr1, 1L, loop);
            cache.cache("netty.io", null, addr2, 10000L, loop);
            List entries = cache.get("netty.io", null);
            Assertions.assertEquals((int)2, (int)entries.size());
            DefaultDnsCacheTest.assertEntry((DnsCacheEntry)entries.get(0), addr1);
            DefaultDnsCacheTest.assertEntry((DnsCacheEntry)entries.get(1), addr2);
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddSameAddressForSameHostname() throws Exception {
        InetAddress addr1 = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
        try {
            EventLoop loop = group.next();
            DefaultDnsCache cache = new DefaultDnsCache();
            cache.cache("netty.io", null, addr1, 1L, loop);
            cache.cache("netty.io", null, addr1, 10000L, loop);
            List entries = cache.get("netty.io", null);
            Assertions.assertEquals((int)1, (int)entries.size());
            DefaultDnsCacheTest.assertEntry((DnsCacheEntry)entries.get(0), addr1);
        }
        finally {
            group.shutdownGracefully();
        }
    }

    private static void assertEntry(DnsCacheEntry entry, InetAddress address) {
        Assertions.assertEquals((Object)address, (Object)entry.address());
        Assertions.assertNull((Object)entry.cause());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCacheFailed() throws Exception {
        InetAddress addr1 = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress addr2 = InetAddress.getByAddress(new byte[]{10, 0, 0, 2});
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
        try {
            EventLoop loop = group.next();
            DefaultDnsCache cache = new DefaultDnsCache(1, 100, 100);
            cache.cache("netty.io", null, addr1, 10000L, loop);
            cache.cache("netty.io", null, addr2, 10000L, loop);
            List entries = cache.get("netty.io", null);
            Assertions.assertEquals((int)2, (int)entries.size());
            DefaultDnsCacheTest.assertEntry((DnsCacheEntry)entries.get(0), addr1);
            DefaultDnsCacheTest.assertEntry((DnsCacheEntry)entries.get(1), addr2);
            Exception exception = new Exception();
            cache.cache("netty.io", null, (Throwable)exception, loop);
            entries = cache.get("netty.io", null);
            DnsCacheEntry entry = (DnsCacheEntry)entries.get(0);
            Assertions.assertEquals((int)1, (int)entries.size());
            Assertions.assertSame((Object)exception, (Object)entry.cause());
            Assertions.assertNull((Object)entry.address());
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDotHandling() throws Exception {
        InetAddress addr1 = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress addr2 = InetAddress.getByAddress(new byte[]{10, 0, 0, 2});
        MultithreadEventLoopGroup group = new MultithreadEventLoopGroup(1, LocalHandler.newFactory());
        try {
            EventLoop loop = group.next();
            DefaultDnsCache cache = new DefaultDnsCache(1, 100, 100);
            cache.cache("netty.io", null, addr1, 10000L, loop);
            cache.cache("netty.io.", null, addr2, 10000L, loop);
            List entries = cache.get("netty.io", null);
            Assertions.assertEquals((int)2, (int)entries.size());
            DefaultDnsCacheTest.assertEntry((DnsCacheEntry)entries.get(0), addr1);
            DefaultDnsCacheTest.assertEntry((DnsCacheEntry)entries.get(1), addr2);
            List entries2 = cache.get("netty.io.", null);
            Assertions.assertEquals((int)2, (int)entries2.size());
            DefaultDnsCacheTest.assertEntry((DnsCacheEntry)entries2.get(0), addr1);
            DefaultDnsCacheTest.assertEntry((DnsCacheEntry)entries2.get(1), addr2);
        }
        finally {
            group.shutdownGracefully();
        }
    }
}

