/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.channel.unix.NativeInetAddress;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NativeInetAddressTest {
    @Test
    public void testAddressNotIncludeScopeId() {
        int port = 80;
        ByteBuffer buffer = ByteBuffer.wrap(new byte[24]);
        buffer.put(new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49});
        buffer.putInt(0);
        buffer.putInt(port);
        InetSocketAddress address = NativeInetAddress.address((byte[])buffer.array(), (int)0, (int)buffer.capacity());
        Assertions.assertEquals((int)port, (int)address.getPort());
        Assertions.assertInstanceOf(Inet6Address.class, (Object)address.getAddress());
        Assertions.assertFalse((boolean)address.getAddress().isLinkLocalAddress());
        Assertions.assertEquals((Object)"3030:3030:3030:3030:3030:3030:3030:3031", (Object)address.getAddress().getHostName());
    }

    @Test
    public void testLinkOnlyAddressIncludeScopeId() {
        int port = 80;
        ByteBuffer buffer = ByteBuffer.wrap(new byte[24]);
        buffer.put(new byte[]{-2, -128, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49});
        buffer.putInt(0);
        buffer.putInt(port);
        InetSocketAddress address = NativeInetAddress.address((byte[])buffer.array(), (int)0, (int)buffer.capacity());
        Assertions.assertEquals((int)port, (int)address.getPort());
        Assertions.assertInstanceOf(Inet6Address.class, (Object)address.getAddress());
        Assertions.assertTrue((boolean)address.getAddress().isLinkLocalAddress());
        Assertions.assertEquals((Object)"fe80:3030:3030:3030:3030:3030:3030:3031%0", (Object)address.getAddress().getHostName());
    }
}

